/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Transform;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.TransformableFigure;
import org.jhotdraw8.draw.handle.AbstractHandle;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jhotdraw8.geom.Points;
import org.jspecify.annotations.Nullable;

public class RelativeControlPointHandle
extends AbstractHandle {
    public static final @Nullable BorderStrokeStyle INSIDE_STROKE = new BorderStrokeStyle(StrokeType.INSIDE, StrokeLineJoin.MITER, StrokeLineCap.BUTT, 1.0, 0.0, null);
    private static final @Nullable Background REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLUE, null, null)});
    private static final @Nullable Border REGION_BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLUE, BorderStrokeStyle.SOLID, null, null)});
    private static final Rectangle REGION_SHAPE = new Rectangle(7.0, 7.0);
    private final Region node;
    private @Nullable Point2D pickLocation;
    private final MapAccessor<Point2D> pointKey;
    private final MapAccessor<Point2D> controlPointKey;

    public RelativeControlPointHandle(Figure figure, MapAccessor<Point2D> pointKey, MapAccessor<Point2D> controlPointKey) {
        super(figure);
        this.pointKey = pointKey;
        this.controlPointKey = controlPointKey;
        this.node = new Region();
        this.node.setShape((Shape)REGION_SHAPE);
        this.node.setManaged(false);
        this.node.setScaleShape(false);
        this.node.setCenterShape(true);
        this.node.resize(11.0, 11.0);
        this.node.setBorder(REGION_BORDER);
        this.node.setBackground(REGION_BACKGROUND);
    }

    @Override
    public boolean contains(DrawingView dv, double x, double y, double tolerance) {
        Point2D p = this.getLocationInView();
        return Points.squaredDistance((double)x, (double)y, (double)p.getX(), (double)p.getY()) <= tolerance * tolerance;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.CROSSHAIR;
    }

    public Point2D getLocationInView() {
        return this.pickLocation;
    }

    public Region getNode(DrawingView view) {
        double size = view.getEditor().getHandleSize();
        if (this.node.getWidth() != size) {
            this.node.resize(size, size);
        }
        CssColor color = view.getEditor().getHandleColor();
        BorderStroke borderStroke = (BorderStroke)this.node.getBorder().getStrokes().getFirst();
        if (borderStroke == null || !borderStroke.getTopStroke().equals(color.getColor())) {
            this.node.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)color.getColor(), INSIDE_STROKE, null, null)}));
        }
        return this.node;
    }

    @Override
    public void onMouseDragged(MouseEvent event, DrawingView view) {
        Point2D newPoint = view.viewToWorld(new Point2D(event.getX(), event.getY()));
        if (!event.isAltDown() && !event.isControlDown()) {
            newPoint = view.getConstrainer().constrainPoint(this.getOwner(), new CssPoint2D(newPoint)).getConvertedValue();
        }
        Point2D localPoint = this.getOwner().worldToLocal(newPoint);
        Point2D point = (Point2D)this.getOwner().get(this.pointKey);
        Point2D controlPoint = localPoint.subtract(point);
        view.getModel().set(this.getOwner(), this.controlPointKey, controlPoint);
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void updateNode(DrawingView view) {
        Figure f = this.getOwner();
        Transform t = FXTransforms.concat((Transform[])new Transform[]{view.getWorldToView(), f.getLocalToWorld()});
        Point2D point = (Point2D)f.get(this.pointKey);
        Point2D controlPoint = (Point2D)f.get(this.controlPointKey);
        Point2D p = point.add(controlPoint);
        this.pickLocation = p = FXTransforms.transform((Transform)t, (Point2D)p);
        double size = this.node.getWidth();
        this.node.relocate(p.getX() - size * 0.5, p.getY() - size * 0.5);
        this.node.setRotate(((Double)f.getStyledNonNull((NonNullMapAccessor)TransformableFigure.ROTATE)).doubleValue());
        this.node.setRotationAxis((Point3D)f.getStyled((MapAccessor)TransformableFigure.ROTATION_AXIS));
    }
}

