/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.handle;

import java.util.Collection;
import java.util.function.Function;
import javafx.scene.Cursor;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.css.value.CssRectangle2D;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.handle.AbstractResizeTransformHandle;
import org.jhotdraw8.draw.handle.Handle;
import org.jhotdraw8.draw.locator.BoundsLocator;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jspecify.annotations.Nullable;

public class ResizeHandleKit {
    protected static final SVGPath NORTH_SHAPE = new SVGPath();
    protected static final SVGPath EAST_SHAPE = new SVGPath();
    protected static final SVGPath WEST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_SHAPE = new SVGPath();
    protected static final SVGPath NORTH_EAST_SHAPE = new SVGPath();
    protected static final SVGPath NORTH_WEST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_EAST_SHAPE = new SVGPath();
    protected static final SVGPath SOUTH_WEST_SHAPE = new SVGPath();
    private static final @Nullable Background REGION_BACKGROUND;
    private static final Function<Color, Border> REGION_BORDER;

    private ResizeHandleKit() {
    }

    public static void addCornerResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.southEast(f));
        handles.add(ResizeHandleKit.southWest(f));
        handles.add(ResizeHandleKit.northEast(f));
        handles.add(ResizeHandleKit.northWest(f));
    }

    public static void addEdgeResizeHandles(Figure f, Collection<Handle> handles) {
        handles.add(ResizeHandleKit.south(f));
        handles.add(ResizeHandleKit.north(f));
        handles.add(ResizeHandleKit.east(f));
        handles.add(ResizeHandleKit.west(f));
    }

    public static void addResizeHandles(Figure f, Collection<Handle> handles) {
        ResizeHandleKit.addCornerResizeHandles(f, handles);
        ResizeHandleKit.addEdgeResizeHandles(f, handles);
    }

    public static Handle south(Figure owner) {
        return new SouthHandle(owner);
    }

    public static Handle southEast(Figure owner) {
        return new SouthEastHandle(owner);
    }

    public static Handle southWest(Figure owner) {
        return new SouthWestHandle(owner);
    }

    public static Handle north(Figure owner) {
        return new NorthHandle(owner);
    }

    public static Handle northEast(Figure owner) {
        return new NorthEastHandle(owner);
    }

    public static Handle northWest(Figure owner) {
        return new NorthWestHandle(owner);
    }

    public static Handle east(Figure owner) {
        return new EastHandle(owner);
    }

    public static Handle west(Figure owner) {
        return new WestHandle(owner);
    }

    static {
        String square = "M 0,0 9,0 9,9 0,9 Z ";
        NORTH_EAST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 0,4.5 4.5,4.5 4.5,9");
        NORTH_WEST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 4.5,9 4.5,4.5 9,4.5 ");
        SOUTH_EAST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 4.5,0 4.5,4.5 0,4.5 ");
        SOUTH_WEST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 9,4.5 4.5,4.5 4.5,0");
        SOUTH_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 0,4.5 9,4.5");
        NORTH_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 0,4.5 9,4.5");
        EAST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 4.5,0 4.5,9");
        WEST_SHAPE.setContent("M 0,0 9,0 9,9 0,9 Z M 4.5,0 4.5,9");
        REGION_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)});
        REGION_BORDER = color -> new Border(new BorderStroke[]{new BorderStroke((Paint)color, BorderStrokeStyle.SOLID, null, null)});
    }

    private static class SouthHandle
    extends AbstractResizeTransformHandle {
        SouthHandle(Figure owner) {
            super(owner, BoundsLocator.SOUTH, (Shape)SOUTH_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.S_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newY = CssSize.max((CssSize)bounds.getMinY(), (CssSize)newPoint.getY());
            CssSize newWidth = bounds.getWidth();
            CssSize newHeight = newY.subtract(bounds.getMinY());
            if (keepAspect) {
                newWidth = newHeight.divide(this.preferredAspectRatio);
            }
            model.reshapeInLocal(owner, bounds.getMinX().add(bounds.getMaxX()).subtract(newWidth).multiply(0.5), bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class SouthEastHandle
    extends AbstractResizeTransformHandle {
        SouthEastHandle(Figure owner) {
            super(owner, BoundsLocator.SOUTH_EAST, (Shape)SOUTH_EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.SE_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newX = CssSize.max((CssSize)newPoint.getX(), (CssSize)bounds.getMinX());
            CssSize newY = CssSize.max((CssSize)newPoint.getY(), (CssSize)bounds.getMinY());
            CssSize newWidth = newX.subtract(bounds.getMinX());
            CssSize newHeight = newY.subtract(bounds.getMinY());
            if (keepAspect) {
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth.multiply(this.preferredAspectRatio);
                } else {
                    newWidth = newHeight.divide(this.preferredAspectRatio);
                }
            }
            model.reshapeInLocal(owner, bounds.getMinX(), bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class SouthWestHandle
    extends AbstractResizeTransformHandle {
        SouthWestHandle(Figure owner) {
            super(owner, BoundsLocator.SOUTH_WEST, (Shape)SOUTH_WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.SW_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newX = CssSize.min((CssSize)newPoint.getX(), (CssSize)bounds.getMaxX());
            CssSize newY = CssSize.max((CssSize)newPoint.getY(), (CssSize)bounds.getMinY());
            CssSize newWidth = bounds.getMaxX().subtract(newX);
            CssSize newHeight = newY.subtract(bounds.getMinY());
            if (keepAspect) {
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth.multiply(this.preferredAspectRatio);
                } else {
                    newWidth = newHeight.divide(this.preferredAspectRatio);
                }
            }
            model.reshapeInLocal(owner, newX, bounds.getMinY(), newWidth, newHeight);
        }
    }

    private static class NorthHandle
    extends AbstractResizeTransformHandle {
        NorthHandle(Figure owner) {
            super(owner, BoundsLocator.NORTH, (Shape)NORTH_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.N_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newY = CssSize.min((CssSize)bounds.getMaxY(), (CssSize)newPoint.getY());
            CssSize newWidth = bounds.getMaxX().subtract(bounds.getMinX());
            CssSize newHeight = bounds.getMaxY().subtract(newY);
            if (keepAspect) {
                newWidth = newHeight.divide(this.preferredAspectRatio);
            }
            model.reshapeInLocal(owner, bounds.getMinX().add(bounds.getMaxX()).subtract(newWidth).multiply(0.5), newY, newWidth, newHeight);
        }
    }

    private static class NorthEastHandle
    extends AbstractResizeTransformHandle {
        NorthEastHandle(Figure owner) {
            super(owner, BoundsLocator.NORTH_EAST, (Shape)NORTH_EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.NE_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newX = CssSize.max((CssSize)newPoint.getX(), (CssSize)bounds.getMinX());
            CssSize newY = CssSize.min((CssSize)newPoint.getY(), (CssSize)bounds.getMaxY());
            CssSize newWidth = newX.subtract(bounds.getMinX());
            CssSize newHeight = bounds.getMaxY().subtract(newY);
            if (keepAspect) {
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth.multiply(this.preferredAspectRatio);
                } else {
                    newWidth = newHeight.divide(this.preferredAspectRatio);
                }
            }
            model.reshapeInLocal(owner, bounds.getMinX(), newY, newWidth, newHeight);
        }
    }

    private static class NorthWestHandle
    extends AbstractResizeTransformHandle {
        NorthWestHandle(Figure owner) {
            super(owner, BoundsLocator.NORTH_WEST, (Shape)NORTH_WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.NW_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newX = CssSize.min((CssSize)bounds.getMaxX(), (CssSize)newPoint.getX());
            CssSize newY = CssSize.min((CssSize)bounds.getMaxY(), (CssSize)newPoint.getY());
            CssSize newWidth = bounds.getMaxX().subtract(newX);
            CssSize newHeight = bounds.getMaxY().subtract(newY);
            if (keepAspect) {
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > this.preferredAspectRatio) {
                    newHeight = newWidth.multiply(this.preferredAspectRatio);
                } else {
                    newWidth = newHeight.divide(this.preferredAspectRatio);
                }
            }
            model.reshapeInLocal(owner, newPoint.getX(), newPoint.getY(), newWidth, newHeight);
        }
    }

    private static class EastHandle
    extends AbstractResizeTransformHandle {
        EastHandle(Figure owner) {
            super(owner, BoundsLocator.EAST, (Shape)EAST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.E_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newWidth = CssSize.max((CssSize)newPoint.getX(), (CssSize)bounds.getMinX()).subtract(bounds.getMinX());
            CssSize newHeight = bounds.getMaxY().subtract(bounds.getMinY());
            if (keepAspect) {
                newHeight = newWidth.multiply(this.preferredAspectRatio);
            }
            model.reshapeInLocal(owner, bounds.getMinX(), bounds.getMinY().add(bounds.getMaxY()).subtract(newHeight).multiply(0.5), newWidth, newHeight);
        }
    }

    private static class WestHandle
    extends AbstractResizeTransformHandle {
        WestHandle(Figure owner) {
            super(owner, BoundsLocator.WEST, (Shape)WEST_SHAPE, REGION_BACKGROUND, REGION_BORDER);
        }

        @Override
        public Cursor getCursor() {
            return Cursor.W_RESIZE;
        }

        @Override
        protected void resize(CssPoint2D newPoint, Figure owner, CssRectangle2D bounds, DrawingModel model, boolean keepAspect) {
            CssSize newX = CssSize.min((CssSize)bounds.getMaxX(), (CssSize)newPoint.getX());
            CssSize newWidth = bounds.getMaxX().subtract(newX);
            CssSize newHeight = bounds.getHeight();
            if (keepAspect) {
                newHeight = newWidth.multiply(this.preferredAspectRatio);
            }
            model.reshapeInLocal(owner, newX, bounds.getMinY().add(bounds.getMaxY()).subtract(newHeight).multiply(0.5), newWidth, newHeight);
        }
    }
}

