/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.input;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import javafx.scene.input.DataFormat;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jspecify.annotations.Nullable;

public class MultiClipboardOutputFormat
implements ClipboardOutputFormat {
    private @Nullable Supplier<ClipboardOutputFormat>[] formatSuppliers;
    private ClipboardOutputFormat[] formats;

    @SafeVarargs
    public MultiClipboardOutputFormat(Supplier<ClipboardOutputFormat> ... formatSuppliers) {
        this.formatSuppliers = formatSuppliers;
    }

    public MultiClipboardOutputFormat(ClipboardOutputFormat ... formats) {
        this.formats = formats;
    }

    private void createFormats() {
        if (this.formatSuppliers != null) {
            int n = this.formatSuppliers.length;
            this.formats = new ClipboardOutputFormat[n];
            for (int i = 0; i < n; ++i) {
                this.formats[i] = this.formatSuppliers[i].get();
            }
            this.formatSuppliers = null;
        }
    }

    @Override
    public void write(Map<DataFormat, Object> out, Drawing drawing, Collection<Figure> selection) throws IOException {
        this.createFormats();
        for (ClipboardOutputFormat f : this.formats) {
            f.write(out, drawing, selection);
        }
    }
}

