/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.util.Collections;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.SetChangeListener;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.inspector.AbstractInspector;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSelectionInspector
extends AbstractInspector<DrawingView> {
    private final SetChangeListener<Figure> selectionListener;
    protected final UndoableEditHelper undoHelper;

    public AbstractSelectionInspector() {
        this.subject.addListener(this::onDrawingViewChanged);
        this.selectionListener = change -> {
            DrawingView drawingView = (DrawingView)this.getSubject();
            this.onSelectionChanged((Set<Figure>)(drawingView == null ? FXCollections.emptyObservableSet() : drawingView.getSelectedFigures()));
        };
        this.undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEdit);
    }

    protected @Nullable Drawing getDrawing() {
        DrawingView subject = (DrawingView)this.getSubject();
        return subject == null ? null : subject.getDrawing();
    }

    protected @Nullable DrawingModel getModel() {
        DrawingView subject = (DrawingView)this.getSubject();
        return subject == null ? null : subject.getModel();
    }

    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        if (oldValue != null) {
            oldValue.selectedFiguresProperty().removeListener(this.selectionListener);
        }
        if (newValue != null) {
            newValue.selectedFiguresProperty().addListener(this.selectionListener);
        }
    }

    protected Set<Figure> getSelectedFigures() {
        DrawingView drawingView = (DrawingView)this.getSubject();
        return drawingView == null ? Collections.emptySet() : drawingView.getSelectedFigures();
    }

    protected abstract void onSelectionChanged(Set<Figure> var1);

    protected void forwardUndoableEdit(UndoableEditEvent event) {
        DrawingEditor editor;
        DrawingView s = (DrawingView)this.getSubject();
        DrawingEditor drawingEditor = editor = s == null ? null : s.getEditor();
        if (editor != null) {
            editor.getUndoManager().undoableEditHappened(event);
        }
    }
}

