/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.converter.SizeCssConverter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.converter.ColorCssConverter;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.ViewBoxableDrawing;
import org.jhotdraw8.draw.inspector.AbstractDrawingInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.LayersInspector;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public class DrawingInspector
extends AbstractDrawingInspector {
    @FXML
    private TextField backgroundColorField;
    @FXML
    private ColorPicker backgroundColorPicker;
    private final Property<CssColor> myBackgroundProperty = new SimpleObjectProperty();
    private @Nullable Property<CssColor> boundBackgroundProperty;
    private final ChangeListener<CssSize> sizeCommitHandler = (o, oldv, newv) -> this.commitEdits();
    private final ChangeListener<CssColor> colorCommitHandler = (o, oldv, newv) -> this.commitEdits();
    @FXML
    private TextField xField;
    @FXML
    private TextField yField;
    @FXML
    private TextField heightField;
    private @Nullable Property<CssSize> xProperty;
    private @Nullable Property<CssSize> yProperty;
    private @Nullable Property<CssSize> heightProperty;
    private Node node;
    @FXML
    private TextField widthField;
    private @Nullable Property<CssSize> widthProperty;

    public DrawingInspector() {
        this(LayersInspector.class.getResource("DrawingInspector.fxml"));
    }

    public DrawingInspector(URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    private void commitEdits() {
        DrawingView subject = (DrawingView)this.getSubject();
        subject.getModel().fireTreeModelEvent(TreeModelEvent.nodeChanged((TreeModel)subject.getModel(), (Object)subject.getDrawing()));
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void init(URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
            CustomBinding.bindBidirectionalAndConvert(this.myBackgroundProperty, (WritableValue)this.backgroundColorPicker.valueProperty(), c -> c == null ? null : c.getColor(), CssColor::new);
            this.backgroundColorField.textProperty().bindBidirectional(this.myBackgroundProperty, (StringConverter)new StringConverterAdapter((Converter)new ColorCssConverter(false)));
        });
    }

    @Override
    protected void onDrawingChanged(@Nullable ObservableValue<? extends Drawing> observable, @Nullable Drawing oldValue, @Nullable Drawing newValue) {
        if (this.widthProperty != null) {
            this.widthField.textProperty().unbindBidirectional(this.widthProperty);
            this.widthProperty.removeListener(this.sizeCommitHandler);
        }
        if (this.heightProperty != null) {
            this.heightField.textProperty().unbindBidirectional(this.heightProperty);
            this.heightProperty.removeListener(this.sizeCommitHandler);
        }
        if (this.xProperty != null) {
            this.xField.textProperty().unbindBidirectional(this.xProperty);
            this.xProperty.removeListener(this.sizeCommitHandler);
        }
        if (this.yProperty != null) {
            this.yField.textProperty().unbindBidirectional(this.yProperty);
            this.yProperty.removeListener(this.sizeCommitHandler);
        }
        this.xProperty = null;
        this.yProperty = null;
        this.widthProperty = null;
        this.heightProperty = null;
        if (oldValue != null) {
            this.myBackgroundProperty.unbindBidirectional(this.boundBackgroundProperty);
            this.myBackgroundProperty.removeListener(this.colorCommitHandler);
            this.boundBackgroundProperty = null;
        }
        if (newValue != null) {
            this.xProperty = this.drawingModel.propertyAt(newValue, ViewBoxableDrawing.VIEW_BOX_X);
            this.yProperty = this.drawingModel.propertyAt(newValue, ViewBoxableDrawing.VIEW_BOX_Y);
            this.widthProperty = this.drawingModel.propertyAt(newValue, ViewBoxableDrawing.WIDTH);
            this.heightProperty = this.drawingModel.propertyAt(newValue, ViewBoxableDrawing.HEIGHT);
            this.boundBackgroundProperty = this.drawingModel.propertyAt(newValue, ViewBoxableDrawing.BACKGROUND);
            this.xProperty.addListener(this.sizeCommitHandler);
            this.yProperty.addListener(this.sizeCommitHandler);
            this.widthProperty.addListener(this.sizeCommitHandler);
            this.heightProperty.addListener(this.sizeCommitHandler);
            this.myBackgroundProperty.bindBidirectional(this.boundBackgroundProperty);
            this.myBackgroundProperty.addListener(this.colorCommitHandler);
            this.xField.textProperty().bindBidirectional(this.xProperty, (StringConverter)new StringConverterAdapter((Converter)new SizeCssConverter(false)));
            this.yField.textProperty().bindBidirectional(this.yProperty, (StringConverter)new StringConverterAdapter((Converter)new SizeCssConverter(false)));
            this.widthField.textProperty().bindBidirectional(this.widthProperty, (StringConverter)new StringConverterAdapter((Converter)new SizeCssConverter(false)));
            this.heightField.textProperty().bindBidirectional(this.heightProperty, (StringConverter)new StringConverterAdapter((Converter)new SizeCssConverter(false)));
        }
    }
}

