/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.inspector.AbstractDrawingViewInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jspecify.annotations.Nullable;

public class HelpTextInspector
extends AbstractDrawingViewInspector {
    @FXML
    private TextArea textArea;
    private Node node;

    public HelpTextInspector() {
        this(HelpTextInspector.class.getResource("HelpTextInspector.fxml"));
    }

    public HelpTextInspector(URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    private void init(URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
        });
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        if (oldValue != null) {
            this.textArea.textProperty().unbind();
        }
        if (newValue != null) {
            this.textArea.textProperty().bind(newValue.getEditor().helpTextProperty());
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }
}

