/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.SetChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TextFieldTreeTableCell;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.text.CachingCollator;
import org.jhotdraw8.base.text.NaturalSortCollator;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.SimpleDrawing;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.inspector.AbstractDrawingViewInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelFigureProperty;
import org.jhotdraw8.draw.model.SimpleDrawingModel;
import org.jhotdraw8.fxbase.control.BooleanPropertyCheckBoxTreeTableCell;
import org.jhotdraw8.fxbase.converter.StringConverterAdapter;
import org.jhotdraw8.fxbase.tree.ExpandedTreeItemIterator;
import org.jhotdraw8.fxbase.tree.SimpleTreePresentationModel;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreePresentationModel;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jhotdraw8.xml.converter.WordListXmlConverter;
import org.jhotdraw8.xml.converter.WordSetXmlConverter;
import org.jspecify.annotations.Nullable;

public class HierarchyInspector
extends AbstractDrawingViewInspector {
    private final Comparator<String> collator = new CachingCollator((Collator)new NaturalSortCollator(Locale.ENGLISH));
    private final WordListXmlConverter wordListConverter = new WordListXmlConverter();
    private final WordSetXmlConverter wordSetConverter = new WordSetXmlConverter();
    private final SimpleDrawingModel stubDrawingModel = new SimpleDrawingModel();
    private @Nullable DrawingView drawingView;
    @FXML
    private TreeTableColumn<Figure, String> idColumn;
    private boolean isUpdatingSelectionInView;
    @FXML
    private TreeTableColumn<Figure, Boolean> lockedColumn;
    private TreePresentationModel<Figure> model;
    private Node node;
    @FXML
    private TreeTableColumn<Figure, ImmutableSet<String>> pseudoClassesColumn;
    @FXML
    private TreeTableColumn<Figure, ImmutableSet<String>> styleClassesColumn;
    @FXML
    private TreeTableView<Figure> treeView;
    private final InvalidationListener treeSelectionHandler = change -> {
        if (!this.model.isUpdating()) {
            this.updateSelectionInDrawingView();
        }
    };
    @FXML
    private TreeTableColumn<Figure, String> typeColumn;
    @FXML
    private TreeTableColumn<Figure, Boolean> visibleColumn;
    private boolean willUpdateSelectionInTree;
    private final SetChangeListener<Figure> viewSelectionHandler = this::updateSelectionInTreeLater;

    public HierarchyInspector() {
        this(HierarchyInspector.class.getResource("HierarchyInspector.fxml"), InspectorLabels.getResources().asResourceBundle());
    }

    public HierarchyInspector(URL fxmlUrl, ResourceBundle resources) {
        this.init(fxmlUrl, resources);
    }

    private Callback<TreeTableView<Figure>, TreeTableRow<Figure>> createRow() {
        return tv -> {
            final ContextMenu contextMenu = new ContextMenu();
            final MenuItem deleteMenuItem = new MenuItem(InspectorLabels.getResources().getString("edit.delete.text"));
            contextMenu.getItems().add((Object)deleteMenuItem);
            TreeTableRow<Figure> row = new TreeTableRow<Figure>(this){

                public void updateItem(Figure item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (empty) {
                        this.setContextMenu(null);
                    } else {
                        this.setContextMenu(contextMenu);
                        deleteMenuItem.setDisable(!item.isDeletable());
                    }
                }
            };
            row.setOnMouseClicked(arg_0 -> this.lambda$createRow$1((TreeTableRow)row, arg_0));
            WeakReference<HierarchyInspector> inspectorRef = new WeakReference<HierarchyInspector>(this);
            WeakReference<1> rowRef = new WeakReference<1>(row);
            deleteMenuItem.setOnAction(evt -> {
                Figure item;
                HierarchyInspector hierarchyInspector = (HierarchyInspector)inspectorRef.get();
                TreeTableRow theRow = (TreeTableRow)rowRef.get();
                if (hierarchyInspector != null && theRow != null && (item = (Figure)theRow.getItem()) != null && item.isDeletable() && hierarchyInspector.drawingView != null) {
                    DrawingModel model = hierarchyInspector.drawingView.getModel();
                    model.disconnect(item);
                    model.removeFromParent(item);
                }
            });
            return row;
        };
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    private void init(URL fxmlUrl, ResourceBundle resources) {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setResources(resources);
        try (InputStream in = fxmlUrl.openStream();){
            this.node = (Node)loader.load(in);
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        Supplier<Map> mapSupplier = IdentityHashMap::new;
        this.model = new SimpleTreePresentationModel(mapSupplier);
        this.stubDrawingModel.setDrawing(new SimpleDrawing());
        this.model.setTreeModel((TreeModel)this.stubDrawingModel);
        this.typeColumn.setCellValueFactory(cell -> new ReadOnlyObjectWrapper(cell.getValue() == null ? null : (cell.getValue().getValue() == null ? null : ((Figure)cell.getValue().getValue()).getTypeSelector())));
        this.idColumn.setCellValueFactory(cell -> new DrawingModelFigureProperty((DrawingModel)this.model.getTreeModel(), cell.getValue() == null ? null : (Figure)cell.getValue().getValue(), StyleableFigure.ID));
        this.visibleColumn.setCellValueFactory(cell -> new DrawingModelFigureProperty((DrawingModel)this.model.getTreeModel(), cell.getValue() == null ? null : (Figure)cell.getValue().getValue(), HideableFigure.VISIBLE));
        this.lockedColumn.setCellValueFactory(cell -> new DrawingModelFigureProperty((DrawingModel)this.model.getTreeModel(), cell.getValue() == null ? null : (Figure)cell.getValue().getValue(), LockableFigure.LOCKED));
        this.styleClassesColumn.setCellValueFactory(cell -> new DrawingModelFigureProperty<ImmutableSet<String>>(this, (DrawingModel)this.model.getTreeModel(), cell.getValue() == null ? null : (Figure)cell.getValue().getValue(), (Key)StyleableFigure.STYLE_CLASS){

            @Override
            public @Nullable ImmutableSet<String> getValue() {
                Figure f = (Figure)this.figure.get();
                return f == null ? null : ChampSet.copyOf((Iterable)f.getStyleClasses());
            }
        });
        this.pseudoClassesColumn.setCellValueFactory(cell -> new DrawingModelFigureProperty<ImmutableSet<String>>(this, (DrawingModel)this.model.getTreeModel(), cell.getValue() == null ? null : (Figure)cell.getValue().getValue(), (Key)StyleableFigure.PSEUDO_CLASS){

            @Override
            public @Nullable ImmutableSet<String> getValue() {
                Figure f = (Figure)this.figure.get();
                return f == null ? null : ChampSet.copyOf((Iterable)f.getPseudoClassStates());
            }
        });
        this.idColumn.setCellFactory((Callback)new Callback<TreeTableColumn<Figure, String>, TreeTableCell<Figure, String>>(this){

            public TreeTableCell<Figure, String> call(TreeTableColumn<Figure, String> paramTableColumn) {
                return new TextFieldTreeTableCell<Figure, String>(this, (StringConverter)new DefaultStringConverter()){

                    public void cancelEdit() {
                        super.cancelEdit();
                        this.updateItem((String)this.getItem(), false);
                    }

                    public void updateItem(String t, boolean empty) {
                        TreeTableRow row = this.getTableRow();
                        boolean isEditable = false;
                        if (row != null) {
                            Figure item = (Figure)row.getItem();
                            if (item != null && item.isEditableKey((MapAccessor<?>)StyleableFigure.ID)) {
                                isEditable = true;
                            }
                            if (item != null) {
                                this.setText(item.getId());
                            }
                        }
                        if (isEditable) {
                            this.setEditable(true);
                            this.setStyle(null);
                        } else {
                            this.setEditable(false);
                            this.setStyle("-fx-text-fill: grey");
                        }
                    }
                };
            }
        });
        this.styleClassesColumn.setCellFactory((Callback)new Callback<TreeTableColumn<Figure, ImmutableSet<String>>, TreeTableCell<Figure, ImmutableSet<String>>>(){

            public TreeTableCell<Figure, ImmutableSet<String>> call(TreeTableColumn<Figure, ImmutableSet<String>> paramTableColumn) {
                return new TextFieldTreeTableCell<Figure, ImmutableSet<String>>(){
                    private final Set<String> syntheticClasses = new HashSet<String>();
                    {
                        this.setConverter((StringConverter)new StringConverterAdapter((Converter)HierarchyInspector.this.wordSetConverter));
                    }

                    public void cancelEdit() {
                        super.cancelEdit();
                        this.updateItem((ImmutableSet<String>)((ImmutableSet)this.getItem()), false);
                        this.syntheticClasses.clear();
                    }

                    public void commitEdit(ImmutableSet<String> newValue) {
                        ImmutableSet newValueSet = newValue.removeAll(this.syntheticClasses);
                        super.commitEdit((Object)newValueSet);
                    }

                    public void startEdit() {
                        Figure figure = (Figure)this.getTableRow().getItem();
                        figure.get((MapAccessor)StyleableFigure.STYLE_CLASS);
                        this.syntheticClasses.clear();
                        this.syntheticClasses.addAll(figure.getStyleClasses().asCollection());
                        this.syntheticClasses.removeAll(((ImmutableSet)figure.getNonNull((NonNullMapAccessor)StyleableFigure.STYLE_CLASS)).asSet());
                        super.startEdit();
                    }

                    public void updateItem(ImmutableSet<String> t, boolean empty) {
                        super.updateItem(t, empty);
                        TreeTableRow row = this.getTableRow();
                        boolean isEditable = false;
                        if (row != null) {
                            Figure figure = (Figure)row.getItem();
                            if (figure != null && figure.isEditableKey((MapAccessor<?>)StyleableFigure.STYLE_CLASS)) {
                                isEditable = true;
                            }
                            if (figure != null) {
                                this.setText(HierarchyInspector.this.wordSetConverter.toString((Object)ChampSet.copyOf((Iterable)figure.getStyleClasses())));
                            }
                        }
                        if (isEditable) {
                            this.setEditable(true);
                            this.setStyle(null);
                        } else {
                            this.setEditable(false);
                            this.setStyle("-fx-text-fill: grey");
                        }
                    }
                };
            }
        });
        this.pseudoClassesColumn.setCellFactory(paramTableColumn -> new TextFieldTreeTableCell<Figure, ImmutableSet<String>>(){
            {
                this.setConverter((StringConverter)new StringConverterAdapter((Converter)HierarchyInspector.this.wordSetConverter));
                this.setEditable(false);
                this.setStyle("-fx-text-fill: grey");
            }
        });
        Comparator<String> comparator = this.collator;
        this.typeColumn.setComparator(comparator);
        this.idColumn.setComparator(comparator);
        this.visibleColumn.setCellFactory(BooleanPropertyCheckBoxTreeTableCell.forTreeTableColumn((String)"visible-check-box"));
        this.lockedColumn.setCellFactory(BooleanPropertyCheckBoxTreeTableCell.forTreeTableColumn((String)"locked-check-box"));
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.treeView.getSelectionModel().getSelectedCells().addListener(this.treeSelectionHandler);
        this.treeView.setRowFactory(this.createRow());
        this.treeView.setRoot(this.model.getRoot());
        this.model.getRoot().setExpanded(true);
        this.showingProperty().addListener(this::onShowingChanged);
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        if (oldValue != null) {
            oldValue.getSelectedFigures().removeListener(this.viewSelectionHandler);
            this.treeView.getProperties().put((Object)"editableComponent", null);
            this.model.setTreeModel((TreeModel)this.stubDrawingModel);
        }
        this.drawingView = newValue;
        if (newValue != null) {
            if (this.isShowing()) {
                this.model.setTreeModel((TreeModel)newValue.getModel());
            }
            newValue.getSelectedFigures().addListener(this.viewSelectionHandler);
            this.treeView.getProperties().put((Object)"editableComponent", (Object)this.drawingView);
        }
    }

    private void onShowingChanged(Observable observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue() && this.model.getTreeModel() == this.stubDrawingModel && this.drawingView != null) {
            this.model.setTreeModel((TreeModel)this.drawingView.getModel());
        }
    }

    private void updateSelectionInDrawingView() {
        if (!this.isUpdatingSelectionInView) {
            this.isUpdatingSelectionInView = true;
            TreeTableView.TreeTableViewSelectionModel selectionModel = this.treeView.getSelectionModel();
            LinkedHashSet<Figure> newSelection = new LinkedHashSet<Figure>();
            for (TreeItem item : selectionModel.getSelectedItems()) {
                if (item == null) continue;
                newSelection.add((Figure)item.getValue());
            }
            DrawingView myDrawingView = this.drawingView;
            if (myDrawingView != null) {
                myDrawingView.getSelectedFigures().retainAll(newSelection);
                myDrawingView.getSelectedFigures().addAll(newSelection);
            }
            this.isUpdatingSelectionInView = false;
        }
    }

    private void updateSelectionInTree() {
        this.willUpdateSelectionInTree = false;
        if (!this.isUpdatingSelectionInView) {
            this.isUpdatingSelectionInView = true;
            TreeTableView.TreeTableViewSelectionModel selectionModel = this.treeView.getSelectionModel();
            DrawingView myDrawingView = this.drawingView;
            Set selection = myDrawingView == null ? Collections.emptySet() : myDrawingView.getSelectedFigures();
            block0 : switch (selection.size()) {
                case 0: {
                    selectionModel.clearSelection();
                    break;
                }
                case 1: {
                    selectionModel.clearSelection();
                    TreeItem treeItem = this.model.getTreeItem((Object)((Figure)selection.iterator().next()));
                    if (treeItem == null) break;
                    selectionModel.select((Object)treeItem);
                    break;
                }
                default: {
                    int index = 0;
                    int count = 0;
                    int size = selection.size();
                    for (TreeItem node : () -> new ExpandedTreeItemIterator(this.model.getRoot())) {
                        boolean isSelected = selection.contains(node.getValue());
                        if (isSelected != selectionModel.isSelected(index)) {
                            if (isSelected) {
                                selectionModel.select(index);
                            } else {
                                selectionModel.clearSelection(index);
                            }
                        }
                        if (isSelected && ++count == size) break block0;
                        ++index;
                    }
                }
            }
            this.isUpdatingSelectionInView = false;
        }
    }

    private void updateSelectionInTreeLater(SetChangeListener.Change<? extends Figure> change) {
        if (!this.willUpdateSelectionInTree && !this.isUpdatingSelectionInView) {
            this.willUpdateSelectionInTree = true;
            Platform.runLater(this::updateSelectionInTree);
        }
    }

    private /* synthetic */ void lambda$createRow$1(TreeTableRow row, MouseEvent event) {
        if (event.getClickCount() == 2 && !row.isEmpty()) {
            Figure rowData = (Figure)row.getItem();
            DrawingView myDrawingView = this.drawingView;
            if (myDrawingView != null) {
                myDrawingView.scrollFigureToVisible(rowData);
            }
        }
    }
}

