/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import javafx.beans.Observable;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.HideableFigure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LockableFigure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.LayersInspector;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jspecify.annotations.Nullable;

public class LayerCell
extends ListCell<Figure> {
    private HBox node;
    @FXML
    private CheckBox visibleCheckBox;
    @FXML
    private CheckBox lockedCheckBox;
    @FXML
    private Label selectionLabel;
    private final WeakReference<DrawingModel> drawingModel;
    private boolean isUpdating;
    private @Nullable Figure item;
    private TextField editField;
    private final LayersInspector inspector;
    private Tooltip selectionLabelTooltip;

    public LayerCell(DrawingModel drawingModel, LayersInspector inspector) {
        this(LayersInspector.class.getResource("LayerCell.fxml"), drawingModel, inspector);
    }

    public LayerCell(URL fxmlUrl, DrawingModel drawingModel, LayersInspector inspector) {
        this.drawingModel = new WeakReference<DrawingModel>(drawingModel);
        this.inspector = inspector;
        this.init(fxmlUrl);
    }

    private void init(URL fxmlUrl) {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        Resources rsrc = InspectorLabels.getResources();
        loader.setResources(rsrc.asResourceBundle());
        try (InputStream in = fxmlUrl.openStream();){
            this.node = (HBox)loader.load(in);
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        this.visibleCheckBox.selectedProperty().addListener(this::commitLayerVisible);
        this.visibleCheckBox.setOnMouseClicked(this::toggleAllVisible);
        this.lockedCheckBox.selectedProperty().addListener(this::commitLayerLocked);
        this.lockedCheckBox.setOnMouseClicked(this::toggleAllLocked);
        this.visibleCheckBox.getStyleClass().add((Object)"visible-check-box");
        this.lockedCheckBox.getStyleClass().add((Object)"locked-check-box");
        this.selectionLabelTooltip = new Tooltip(rsrc.getString("figures.dragToLayer.toolTipText"));
    }

    private void toggleAllVisible(MouseEvent e) {
        if (e.isShiftDown()) {
            e.consume();
            DrawingModel m = (DrawingModel)this.drawingModel.get();
            if (m != null) {
                this.inspector.getUndoHelper().startCompositeEdit(null);
                boolean toggle = !this.visibleCheckBox.isSelected();
                for (Figure f : this.inspector.getListView().getItems()) {
                    m.set(f, HideableFigure.VISIBLE, toggle);
                }
                this.inspector.getUndoHelper().stopCompositeEdit();
            }
        }
    }

    private void toggleAllLocked(MouseEvent e) {
        if (e.isShiftDown()) {
            e.consume();
            DrawingModel m = (DrawingModel)this.drawingModel.get();
            if (m != null) {
                this.inspector.getUndoHelper().startCompositeEdit(null);
                boolean toggle = !this.lockedCheckBox.isSelected();
                for (Figure f : this.inspector.getListView().getItems()) {
                    m.set(f, LockableFigure.LOCKED, toggle);
                }
                this.inspector.getUndoHelper().stopCompositeEdit();
            }
        }
    }

    protected void updateItem(@Nullable Figure item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
            this.item = null;
        } else {
            this.isUpdating = true;
            this.item = item;
            if (this.isEditing()) {
                if (this.editField == null) {
                    this.editField = this.createTextField();
                }
                this.editField.setText(this.getItemText());
                this.setText(null);
                if (this.editField.getParent() == null) {
                    this.node.getChildren().add((Object)this.editField);
                }
            } else {
                this.setText(this.getItemText());
                if (this.editField != null && this.editField.getParent() != null) {
                    this.node.getChildren().remove((Object)this.editField);
                }
            }
            this.setGraphic((Node)this.node);
            int count = this.inspector.getSelectionCount((Layer)item);
            this.selectionLabel.setText(count == 0 ? null : "\u274f\u2009" + count);
            this.selectionLabel.setTooltip(count == 0 ? null : this.selectionLabelTooltip);
            this.visibleCheckBox.setSelected(((Boolean)item.get((MapAccessor)HideableFigure.VISIBLE)).booleanValue());
            this.lockedCheckBox.setSelected(((Boolean)item.get((MapAccessor)LockableFigure.LOCKED)).booleanValue());
            this.isUpdating = false;
        }
    }

    public static Callback<ListView<Figure>, ListCell<Figure>> forListView(DrawingModel drawingModel, LayersInspector inspector) {
        return list -> new LayerCell(drawingModel, inspector);
    }

    private void commitLayerVisible(Observable o) {
        DrawingModel m;
        if (!this.isUpdating && (m = (DrawingModel)this.drawingModel.get()) != null) {
            m.set(this.item, HideableFigure.VISIBLE, this.visibleCheckBox.isSelected());
        }
    }

    private void commitLayerLocked(Observable o) {
        DrawingModel m;
        if (!this.isUpdating && (m = (DrawingModel)this.drawingModel.get()) != null) {
            m.set(this.item, LockableFigure.LOCKED, this.lockedCheckBox.isSelected());
        }
    }

    public Label getSelectionLabel() {
        return this.selectionLabel;
    }

    public final @Nullable StringConverter<Figure> getConverter() {
        return null;
    }

    public void startEdit() {
        if (!this.isEditable() || !this.getListView().isEditable()) {
            return;
        }
        super.startEdit();
        this.updateItem((Figure)this.getItem(), false);
        this.editField.selectAll();
        this.editField.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.updateItem((Figure)this.getItem(), false);
    }

    private String getItemText() {
        return this.getItem() == null ? "" : (String)((Figure)this.getItem()).get((MapAccessor)StyleableFigure.ID);
    }

    private TextField createTextField() {
        TextField textField = new TextField();
        textField.setOnAction(event -> {
            this.commitEdit(this.item);
            event.consume();
        });
        textField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        return textField;
    }

    public void commitEdit(Figure newValue) {
        DrawingModel m;
        if (this.editField != null && this.isEditing() && (m = (DrawingModel)this.drawingModel.get()) != null) {
            m.set(this.item, StyleableFigure.ID, this.editField.getText());
        }
        super.commitEdit((Object)newValue);
    }
}

