/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.manager.StylesheetsManager;
import org.jhotdraw8.css.model.SelectorModel;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.css.model.FigureSelectorModel;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.inspector.AbstractStyleAttributesInspector;
import org.jhotdraw8.draw.inspector.Inspector;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxbase.styleable.WritableStyleableMapAccessor;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jspecify.annotations.Nullable;

public class StyleAttributesInspector
extends AbstractStyleAttributesInspector<Figure>
implements Inspector<DrawingView> {
    protected final ObjectProperty<DrawingView> subject = new SimpleObjectProperty((Object)this, "subject");
    private final InvalidationListener modelInvalidationHandler = this::invalidateTextArea;
    private final Listener<TreeModelEvent<Figure>> treeModelListener = event -> this.invalidateTextArea((Observable)event.getSource());
    private final ChangeListener<DrawingModel> modelChangeHandler = (observable, oldValue, newValue) -> {
        if (oldValue != null) {
            oldValue.removeListener(this.modelInvalidationHandler);
            oldValue.removeTreeModelListener(this.treeModelListener);
        }
        if (newValue != null) {
            newValue.addListener(this.modelInvalidationHandler);
            newValue.addTreeModelListener(this.treeModelListener);
        }
    };

    public StyleAttributesInspector() {
        this.subject.addListener(this::onDrawingViewChanged);
    }

    @Override
    public ObjectProperty<DrawingView> subjectProperty() {
        return this.subject;
    }

    @Override
    protected void fireInvalidated(Figure f) {
        DrawingModel m = this.getDrawingModel();
        m.fireStyleInvalidated(f);
        m.fireNodeInvalidated(f);
        m.fireTransformInvalidated(f);
        m.fireLayoutInvalidated(f);
    }

    @Override
    protected @Nullable Object get(Figure f, WritableStyleableMapAccessor<Object> finalSelectedAccessor) {
        return this.getDrawingModel().get(f, finalSelectedAccessor);
    }

    @Override
    protected @Nullable WritableStyleableMapAccessor<?> getAccessor(SelectorModel<Figure> selectorModel, Figure f, String propertyNamespace, String propertyName) {
        if (selectorModel instanceof FigureSelectorModel) {
            FigureSelectorModel m = (FigureSelectorModel)selectorModel;
            return m.getAccessor(f, propertyNamespace, propertyName);
        }
        return null;
    }

    @Override
    protected @Nullable Converter<?> getConverter(SelectorModel<Figure> selectorModel, Figure f, String namespace, String name) {
        if (selectorModel instanceof FigureSelectorModel) {
            FigureSelectorModel m = (FigureSelectorModel)selectorModel;
            return m.getConverter(f, namespace, name);
        }
        return null;
    }

    protected @Nullable Drawing getDrawing() {
        DrawingView view = (DrawingView)this.getSubject();
        return view == null ? null : view.getDrawing();
    }

    protected @Nullable DrawingModel getDrawingModel() {
        DrawingView view = (DrawingView)this.getSubject();
        return view == null ? null : view.getModel();
    }

    @Override
    protected Iterable<Figure> getEntities() {
        return this.getDrawing().breadthFirstIterable();
    }

    @Override
    protected @Nullable Figure getRoot() {
        DrawingView subject = (DrawingView)this.getSubject();
        return subject == null ? null : subject.getDrawing();
    }

    @Override
    protected @Nullable StylesheetsManager<Figure> getStyleManager() {
        Drawing d = this.getDrawing();
        return d == null ? null : d.getStyleManager();
    }

    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        if (oldValue != null) {
            oldValue.modelProperty().removeListener(this.modelChangeHandler);
            this.modelChangeHandler.changed(oldValue.modelProperty(), (Object)oldValue.getModel(), null);
            this.selectionProperty().unbind();
        }
        if (newValue != null) {
            newValue.modelProperty().addListener(this.modelChangeHandler);
            this.modelChangeHandler.changed(newValue.modelProperty(), null, (Object)newValue.getModel());
            this.invalidateTextArea((Observable)observable);
            this.selectionProperty().bind(newValue.selectedFiguresProperty());
        }
    }

    @Override
    protected void remove(Figure f, WritableStyleableMapAccessor<Object> finalSelectedAccessor) {
        this.getDrawingModel().remove(f, finalSelectedAccessor);
    }

    @Override
    protected void set(Figure f, WritableStyleableMapAccessor<Object> finalSelectedAccessor, Object o) {
        this.getDrawingModel().set(f, finalSelectedAccessor, o);
    }

    @Override
    protected void setHelpText(String helpText) {
        DrawingEditor editor;
        DrawingView view = (DrawingView)this.getSubject();
        DrawingEditor drawingEditor = editor = view == null ? null : view.getEditor();
        if (editor != null) {
            editor.setHelpText(helpText);
        }
    }

    @Override
    protected void showSelection() {
        DrawingView drawingView = (DrawingView)this.getSubject();
        if (drawingView != null) {
            drawingView.scrollSelectedFiguresToVisible();
            drawingView.jiggleHandles();
        }
    }

    @Override
    protected void recreateHandles() {
        DrawingView drawingView = (DrawingView)this.getSubject();
        if (drawingView != null) {
            drawingView.recreateHandles();
        }
    }

    @Override
    protected void forwardUndoableEdit(UndoableEditEvent event) {
        DrawingEditor editor;
        DrawingView s = (DrawingView)this.getSubject();
        DrawingEditor drawingEditor = editor = s == null ? null : s.getEditor();
        if (editor != null) {
            editor.getUndoManager().undoableEditHappened(event);
        }
    }
}

