/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.LayersInspector;
import org.jhotdraw8.draw.inspector.StyleClassItem;
import org.jhotdraw8.draw.inspector.StyleClassesInspector;
import org.jspecify.annotations.Nullable;

public class StyleClassCell
extends ListCell<StyleClassItem> {
    private HBox node;
    private @Nullable StyleClassItem item;
    private boolean isUpdating;
    @FXML
    private Button removeButton;
    private final StyleClassesInspector inspector;

    public StyleClassCell(StyleClassesInspector inspector) {
        this(LayersInspector.class.getResource("StyleClassCell.fxml"), inspector);
    }

    public StyleClassCell(URL fxmlUrl, StyleClassesInspector inspector) {
        this.init(fxmlUrl);
        this.inspector = inspector;
    }

    private void init(URL fxmlUrl) {
        FXMLLoader loader = new FXMLLoader();
        loader.setController((Object)this);
        loader.setResources(InspectorLabels.getResources().asResourceBundle());
        try (InputStream in = fxmlUrl.openStream();){
            this.node = (HBox)loader.load(in);
            this.removeButton.addEventHandler(ActionEvent.ACTION, o -> this.inspector.removeTag(this.item.getText()));
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
    }

    protected void updateItem(@Nullable StyleClassItem item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
            this.item = null;
        } else {
            this.isUpdating = true;
            this.item = item;
            this.setText((String)(item.isInAllElements() ? item.getText() : "(" + item.getText() + ")"));
            this.setGraphic((Node)this.node);
        }
    }

    public static Callback<ListView<StyleClassItem>, ListCell<StyleClassItem>> forListView(StyleClassesInspector inspector) {
        return list -> new StyleClassCell(inspector);
    }
}

