/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.inspector.AbstractSelectionInspector;
import org.jhotdraw8.draw.inspector.InspectorLabels;
import org.jhotdraw8.draw.inspector.StyleClassCell;
import org.jhotdraw8.draw.inspector.StyleClassItem;
import org.jhotdraw8.draw.key.WordSetKey;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.fxbase.concurrent.PlatformUtil;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.ChampSet;
import org.jhotdraw8.icollection.immutable.ImmutableSet;
import org.jspecify.annotations.Nullable;

public class StyleClassesInspector
extends AbstractSelectionInspector {
    @FXML
    private Button addButton;
    private final Listener<DrawingModelEvent> drawingModelEventListener = change -> {
        DrawingView drawingView = (DrawingView)this.getSubject();
        if (change.getEventType() == DrawingModelEvent.EventType.PROPERTY_VALUE_CHANGED && change.getKey() == StyleableFigure.STYLE_CLASS && drawingView != null && drawingView.getSelectedFigures().contains((Object)change.getNode())) {
            this.updateListLater();
        }
    };
    private final Supplier<Collection<String>> listFactory = FXCollections::observableArrayList;
    @FXML
    private ListView<StyleClassItem> listView;
    private final @Nullable ChangeListener<DrawingModel> modelListener = (o, oldv, newv) -> {
        if (oldv != null) {
            oldv.removeDrawingModelListener(this.drawingModelEventListener);
        }
        if (newv != null) {
            newv.addDrawingModelListener(this.drawingModelEventListener);
        }
    };
    private Node node;
    @FXML
    private Button removeButton;
    private final WordSetKey tagsKey = StyleableFigure.STYLE_CLASS;
    @FXML
    private TextField textField;
    private boolean willUpdateList;

    public StyleClassesInspector() {
        this(StyleClassesInspector.class.getResource("StyleClassesInspector.fxml"));
    }

    public StyleClassesInspector(URL fxmlUrl) {
        this.init(fxmlUrl);
    }

    public void addTag(String wordList) {
        this.undoHelper.startCompositeEdit(null);
        for (String tagName : wordList.split(" ")) {
            if (tagName == null || tagName.trim().isEmpty()) continue;
            tagName = tagName.trim();
            for (Figure f : this.getSelectedFigures()) {
                ImmutableSet tags = (ImmutableSet)f.get((MapAccessor)this.tagsKey);
                Collection<String> newTags = this.listFactory.get();
                boolean contains = false;
                for (String t : tags) {
                    if (tagName.equals(t)) {
                        contains = true;
                    }
                    newTags.add(t);
                }
                if (contains) continue;
                newTags.add(tagName);
                this.getModel().set(f, this.tagsKey, ChampSet.copyOf(newTags));
            }
            this.updateList();
        }
        this.undoHelper.stopCompositeEdit();
    }

    @Override
    protected void onDrawingViewChanged(ObservableValue<? extends DrawingView> observable, @Nullable DrawingView oldValue, @Nullable DrawingView newValue) {
        super.onDrawingViewChanged(observable, oldValue, newValue);
        if (oldValue != null) {
            oldValue.modelProperty().removeListener(this.modelListener);
            this.modelListener.changed(oldValue.modelProperty(), (Object)oldValue.getModel(), null);
        }
        if (newValue != null) {
            newValue.modelProperty().removeListener(this.modelListener);
            this.modelListener.changed(newValue.modelProperty(), null, (Object)newValue.getModel());
        }
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    protected void onSelectionChanged(Set<Figure> newValue) {
        this.updateListLater();
    }

    private void init(URL fxmlUrl) {
        PlatformUtil.invokeAndWait(() -> {
            FXMLLoader loader = new FXMLLoader();
            loader.setResources(InspectorLabels.getResources().asResourceBundle());
            loader.setController((Object)this);
            try (InputStream in = fxmlUrl.openStream();){
                this.node = (Node)loader.load(in);
            }
            catch (IOException ex) {
                throw new InternalError(ex);
            }
            this.listView.setCellFactory(StyleClassCell.forListView(this));
            this.listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            this.textField.addEventHandler(ActionEvent.ACTION, o -> this.addTag(this.textField.getText()));
            this.addButton.addEventHandler(ActionEvent.ACTION, o -> this.addTag(this.textField.getText()));
            this.removeButton.addEventHandler(ActionEvent.ACTION, o -> this.removeTag(this.textField.getText()));
        });
    }

    public void removeTag(String wordList) {
        for (String tagName : wordList.split(" ")) {
            if (tagName == null || tagName.trim().isEmpty()) continue;
            tagName = tagName.trim();
            for (Figure f : this.getSelectedFigures()) {
                ImmutableSet tags = (ImmutableSet)f.get((MapAccessor)this.tagsKey);
                Collection<String> newTags = this.listFactory.get();
                boolean contains = false;
                for (String t : tags) {
                    if (tagName.equals(t)) {
                        contains = true;
                        continue;
                    }
                    newTags.add(t);
                }
                if (!contains) continue;
                this.getModel().set(f, this.tagsKey, ChampSet.copyOf(newTags));
            }
            this.updateList();
        }
    }

    protected void updateList() {
        Set<Figure> newValue = this.getSelectedFigures();
        HashSet union = new HashSet();
        HashSet intersection = new HashSet();
        boolean first = true;
        for (Figure f : newValue) {
            ImmutableSet tags = (ImmutableSet)f.getNonNull((NonNullMapAccessor)this.tagsKey);
            if (first) {
                intersection.addAll(tags.asSet());
                first = false;
            } else if (!intersection.isEmpty()) {
                intersection.retainAll(tags.asSet());
            }
            if (tags.isEmpty()) continue;
            union.addAll(tags.asSet());
        }
        ObservableList items = this.listView.getItems();
        items.clear();
        ArrayList unionList = new ArrayList(union);
        Collections.sort(unionList);
        for (String t : unionList) {
            items.add((Object)new StyleClassItem(t, intersection.contains(t)));
        }
    }

    protected void updateListLater() {
        if (!this.willUpdateList) {
            this.willUpdateList = true;
            Platform.runLater(this::updateListNow);
        }
    }

    protected void updateListNow() {
        this.willUpdateList = false;
        this.updateList();
    }
}

