/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.inspector;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class ToolsToolbar
extends GridPane {
    private final ToggleGroup group = new ToggleGroup();
    private final ObjectProperty<DrawingEditor> editor = new SimpleObjectProperty((Object)this, "editor");
    private final ChangeListener<Tool> activeToolHandler;

    public ToolsToolbar(DrawingEditor editor) {
        this.group.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && this.getDrawingEditor() != null) {
                Tool userData = (Tool)newValue.getUserData();
                this.getDrawingEditor().setActiveTool(userData);
            }
        });
        this.activeToolHandler = (o, oldValue, newValue) -> {
            for (Toggle button : this.group.getToggles()) {
                if (button.getUserData() != newValue) continue;
                button.setSelected(true);
                break;
            }
        };
        this.editor.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.activeToolProperty().removeListener(this.activeToolHandler);
            }
            if (newValue != null) {
                newValue.activeToolProperty().addListener(this.activeToolHandler);
                if (this.group.getSelectedToggle() != null) {
                    newValue.setActiveTool((Tool)this.group.getSelectedToggle().getUserData());
                }
            }
        });
        this.setDrawingEditor(editor);
    }

    public ToggleButton addTool(Tool tool, int gridx, int gridy) {
        return this.addTool(tool, gridx, gridy, 0.0);
    }

    public ToggleButton addTool(Tool tool, int gridx, int gridy, double marginLeft) {
        String styleClass;
        ToggleButton button = new ToggleButton();
        if (tool.get((MapAccessor)Tool.LARGE_ICON_KEY) != null) {
            button.setGraphic((Node)tool.get((MapAccessor)Tool.LARGE_ICON_KEY));
            if (tool.get((MapAccessor)Tool.SHORT_DESCRIPTION) != null) {
                button.setTooltip(new Tooltip((String)tool.get((MapAccessor)Tool.SHORT_DESCRIPTION)));
            }
        } else {
            button.setText(tool.getName());
        }
        if ((styleClass = (String)tool.get((MapAccessor)Tool.STYLE_CLASS_KEY)) != null) {
            button.getStyleClass().add((Object)styleClass);
        }
        button.setFocusTraversable(false);
        button.setUserData((Object)tool);
        if (this.group.getToggles().isEmpty()) {
            button.setSelected(true);
        }
        this.group.getToggles().add((Object)button);
        this.add((Node)button, gridx, gridy);
        GridPane.setMargin((Node)button, (Insets)new Insets(0.0, 0.0, 0.0, marginLeft));
        return button;
    }

    public ObjectProperty<DrawingEditor> drawingEditor() {
        return this.editor;
    }

    public DrawingEditor getDrawingEditor() {
        return (DrawingEditor)this.editor.get();
    }

    public void setDrawingEditor(DrawingEditor editor) {
        this.editor.set((Object)editor);
    }
}

