/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Transform;
import org.jhotdraw8.base.converter.SimpleIdFactory;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Page;
import org.jhotdraw8.draw.figure.Slice;
import org.jhotdraw8.draw.io.ExportOutputFormat;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.draw.render.SimpleDrawingRenderer;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.icollection.ChampMap;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public abstract class AbstractExportOutputFormat
implements ExportOutputFormat {
    private ImmutableMap<Key<?>, Object> options = ChampMap.of();

    protected abstract String getExtension();

    public boolean isExportDrawing() {
        return (Boolean)EXPORT_DRAWING_KEY.getNonNull(this.getOptions());
    }

    public boolean isExportPages() {
        return (Boolean)EXPORT_PAGES_KEY.getNonNull(this.getOptions());
    }

    public boolean isExportSlices() {
        return (Boolean)EXPORT_SLICES_KEY.getNonNull(this.getOptions());
    }

    public boolean isExportSlices2x() {
        return (Boolean)EXPORT_SLICES_RESOLUTION_2X_KEY.getNonNull(this.getOptions());
    }

    public boolean isExportSlices3x() {
        return (Boolean)EXPORT_SLICES_RESOLUTION_3X_KEY.getNonNull(this.getOptions());
    }

    protected abstract boolean isResolutionIndependent();

    protected abstract void writePage(Path var1, Page var2, Node var3, int var4, int var5, int var6) throws IOException;

    protected void writePages(@Nullable Path dir, String basename, Drawing drawing) throws IOException {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (Figure f : drawing.preorderIterable()) {
            if (!(f instanceof Page)) continue;
            pages.add((Page)f);
        }
        HashMap hints = new HashMap();
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        RenderContext.DPI.put(hints, (Object)((Double)EXPORT_PAGES_DPI_KEY.get(this.getOptions())));
        this.writePages(dir, basename, drawing, pages, hints);
    }

    protected void writePages(@Nullable Path dir, String basename, Drawing drawing, List<Page> pages, Map<Key<?>, Object> hints) throws IOException {
        SimpleIdFactory idFactory = new SimpleIdFactory();
        int numberOfPages = 0;
        for (Page page : pages) {
            if (page.getId() != null) {
                idFactory.putIdAndObject(page.getId(), (Object)page);
            }
            numberOfPages += page.getNumberOfSubPages();
        }
        int pageNumber = 0;
        SimpleDrawingRenderer renderer = new SimpleDrawingRenderer();
        Group rootNode = new Group();
        Group parentOfPageNode = new Group();
        for (Page page : pages) {
            int n = page.getNumberOfSubPages();
            for (int internalPageNumber = 0; internalPageNumber < n; ++internalPageNumber) {
                Path filename = dir == null ? null : dir.resolve(basename + "_" + (pageNumber + 1) + "." + this.getExtension());
                hints.put(RenderContext.RENDER_PAGE, page);
                hints.put(RenderContext.RENDER_NUMBER_OF_PAGES, numberOfPages);
                hints.put(RenderContext.RENDER_PAGE_NUMBER, pageNumber);
                hints.put(RenderContext.RENDER_PAGE_INTERNAL_NUMBER, internalPageNumber);
                hints.put(RenderContext.RENDER_TIMESTAMP, Instant.now());
                renderer.getProperties().putAll(hints);
                renderer.render(drawing);
                Node pageNode = renderer.getNode(page);
                Node drawingNode = renderer.getNode(drawing);
                Shape pageClip = page.getPageClip(internalPageNumber);
                Transform localToWorld = page.getWorldToLocal();
                Group parentOfDrawing = new Group();
                drawingNode.getTransforms().setAll((Object[])new Transform[]{localToWorld});
                Transform pageLocalToWorld = page.getLocalToWorld();
                parentOfDrawing.getTransforms().setAll((Object[])new Transform[]{pageLocalToWorld});
                parentOfDrawing.getChildren().add((Object)drawingNode);
                parentOfDrawing.setClip((Node)pageClip);
                Group oldParentOfPageNode = (Group)pageNode.getParent();
                if (oldParentOfPageNode != null) {
                    oldParentOfPageNode.getChildren().remove((Object)pageNode);
                }
                parentOfPageNode.getChildren().setAll((Object[])new Node[]{pageNode});
                rootNode.getChildren().setAll((Object[])new Node[]{parentOfDrawing, parentOfPageNode});
                this.writePage(filename, page, (Node)rootNode, numberOfPages, pageNumber, internalPageNumber);
                ++pageNumber;
            }
        }
    }

    protected abstract boolean writeSlice(Path var1, Slice var2, Node var3, double var4) throws IOException;

    protected void writeSlices(@Nullable Path dir, Drawing drawing) throws IOException {
        ArrayList<Slice> slices = new ArrayList<Slice>();
        for (Figure f : drawing.preorderIterable()) {
            if (!(f instanceof Slice)) continue;
            slices.add((Slice)f);
        }
        double slicesDpi = (Double)EXPORT_SLICES_DPI_KEY.get(this.getOptions());
        this.writeSlices(dir, drawing, slices, "", slicesDpi);
        if (!this.isResolutionIndependent()) {
            if (((Boolean)EXPORT_SLICES_RESOLUTION_2X_KEY.get(this.getOptions())).booleanValue()) {
                this.writeSlices(dir, drawing, slices, "@2x", 2.0 * slicesDpi);
            }
            if (((Boolean)EXPORT_SLICES_RESOLUTION_3X_KEY.get(this.getOptions())).booleanValue()) {
                this.writeSlices(dir, drawing, slices, "@3x", 3.0 * slicesDpi);
            }
        }
    }

    private void writeSlices(Path dir, Drawing drawing, List<Slice> slices, String suffix, double dpi) throws IOException {
        HashMap hints = new HashMap();
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        RenderContext.DPI.put(hints, (Object)dpi);
        SimpleIdFactory idFactory = new SimpleIdFactory();
        for (Figure figure : slices) {
            if (figure.getId() == null) continue;
            idFactory.putIdAndObject(figure.getId(), (Object)figure);
        }
        Node node = null;
        for (Slice slice : slices) {
            boolean destroyedNode;
            Path filename = dir.resolve(idFactory.createId((Object)slice, "Slice") + suffix + "." + this.getExtension());
            if (node == null) {
                node = SimpleDrawingRenderer.toNode(drawing, Collections.singleton(drawing), hints);
            }
            if (!(destroyedNode = this.writeSlice(filename, slice, node, dpi))) continue;
            node = null;
        }
    }

    @Override
    public ImmutableMap<Key<?>, Object> getOptions() {
        return this.options;
    }

    @Override
    public void setOptions(ImmutableMap<Key<?>, Object> options) {
        this.options = options;
    }
}

