/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.io.FigureFactory;
import org.jhotdraw8.draw.io.SimpleFigureIdFactory;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jspecify.annotations.Nullable;
import org.w3c.dom.Node;

public abstract class AbstractFigureFactory
implements FigureFactory {
    private static final Logger LOGGER = Logger.getLogger(AbstractFigureFactory.class.getName());
    private final Map<Class<? extends Figure>, HashMap<String, MapAccessor<?>>> attrToKey = new HashMap();
    private final Map<FigureAccessorKey<?>, Object> defaultValueMap = new HashMap();
    private final Map<Class<? extends Figure>, HashMap<String, MapAccessor<?>>> elemToKey = new HashMap();
    private final Map<Class<? extends Figure>, HashSet<MapAccessor<?>>> figureAttributeKeys = new HashMap();
    private final Map<Class<? extends Figure>, HashSet<MapAccessor<?>>> figureNodeListKeys = new HashMap();
    private final Map<Class<? extends Figure>, String> figureToName = new HashMap<Class<? extends Figure>, String>();
    private final Map<Class<? extends Figure>, HashMap<MapAccessor<?>, String>> keyToAttr = new HashMap();
    private final Map<Class<? extends Figure>, HashMap<MapAccessor<?>, String>> keyToElem = new HashMap();
    private final Map<MapAccessor<?>, Converter<?>> keyValueFromXML = new HashMap();
    private final Map<MapAccessor<?>, Converter<?>> keyValueToXML = new HashMap();
    private final Map<String, Supplier<Figure>> nameToFigure = new HashMap<String, Supplier<Figure>>();
    private String objectIdAttribute = "id";
    private final Map<String, HashSet<Class<? extends Figure>>> skipAttributes = new HashMap<String, HashSet<Class<? extends Figure>>>();
    private final Set<String> skipElements = new HashSet<String>();
    private final Set<Class<? extends Figure>> skipFigures = new HashSet<Class<? extends Figure>>();
    private final Map<Type, Converter<?>> valueFromXML = new HashMap();
    private final Map<Type, Converter<?>> valueToXML = new HashMap();
    private @Nullable IdFactory idFactory;

    public AbstractFigureFactory() {
        this((IdFactory)new SimpleFigureIdFactory());
    }

    public AbstractFigureFactory(@Nullable IdFactory idFactory) {
        Objects.requireNonNull(idFactory, "idFactory");
        this.idFactory = idFactory;
    }

    public <T> void addConverter(MapAccessor<T> key, Converter<T> converter) {
        this.keyValueToXML.put(key, converter);
        this.keyValueFromXML.put(key, converter);
    }

    public void addConverterForType(Type fullValueType, Converter<?> converter) {
        this.addConverterForType(fullValueType, converter, false);
    }

    public void addConverterForType(Type fullValueType, Converter<?> converter, boolean force) {
        if (!force && this.valueToXML.containsKey(fullValueType)) {
            throw new IllegalStateException("you already added " + String.valueOf(fullValueType));
        }
        this.valueToXML.put(fullValueType, converter);
        this.valueFromXML.put(fullValueType, converter);
    }

    public <T> void addDefaultValue(Class<? extends Figure> figure, MapAccessor<T> acc, T value) {
        this.defaultValueMap.put(new FigureAccessorKey<T>(figure, acc), value);
    }

    public void addFigure(String name, Class<? extends Figure> figureClass) {
        Constructor<? extends Figure> declaredConstructor;
        try {
            declaredConstructor = figureClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("no no-args constructor in " + String.valueOf(figureClass), e);
        }
        this.nameToFigure.put(name, () -> {
            try {
                return (Figure)declaredConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new InternalError("Couldn't instantiate " + String.valueOf(figureClass), e);
            }
        });
        this.figureToName.put(figureClass, name);
    }

    public void addFigureAttributeKeys(Class<? extends Figure> f, Iterable<MapAccessor<?>> keys) {
        for (MapAccessor<?> key : keys) {
            this.addKey(f, key.getName(), key);
        }
    }

    public void addFigureKeysAndNames(String figureName, Class<? extends Figure> f) {
        this.addFigureKeysAndNames(figureName, f, (Iterable<MapAccessor<?>>)Figure.getDeclaredAndInheritedMapAccessors(f));
    }

    public void addFigureKeysAndNames(String figureName, Class<? extends Figure> f, Iterable<MapAccessor<?>> keys) {
        this.addFigure(figureName, f);
        this.addFigureAttributeKeys(f, keys);
        for (MapAccessor<?> key : keys) {
            this.addKey(f, key.getName(), key);
        }
    }

    public void addFigureKeysAndNames(Class<? extends Figure> f, Collection<MapAccessor<?>> keys) {
        this.addFigureAttributeKeys(f, keys);
        for (MapAccessor<?> key : keys) {
            this.addKey(f, key.getName(), key);
        }
    }

    public void addKey(Class<? extends Figure> figure, String name, MapAccessor<?> key) {
        this.figureAttributeKeys.computeIfAbsent(figure, k -> new HashSet()).add(key);
        HashMap strToKey = this.attrToKey.computeIfAbsent(figure, k -> new HashMap());
        strToKey.putIfAbsent(name, key);
        HashMap keyToStr = this.keyToAttr.computeIfAbsent(figure, k -> new HashMap());
        keyToStr.putIfAbsent(key, name);
    }

    public void addKeys(Class<? extends Figure> f, HashMap<String, MapAccessor<?>> keys) {
        for (Map.Entry<String, MapAccessor<?>> entry : keys.entrySet()) {
            this.addKey(f, entry.getKey(), entry.getValue());
        }
    }

    public void addNodeListKey(Class<? extends Figure> figure, String name, MapAccessor<?> key) {
        HashMap keyToStr;
        if (this.figureNodeListKeys.containsKey(figure)) {
            this.figureNodeListKeys.get(figure).add(key);
        } else {
            HashSet hset = new HashSet();
            hset.add(key);
            this.figureNodeListKeys.put(figure, hset);
        }
        HashMap strToKey = this.elemToKey.computeIfAbsent(figure, k -> new HashMap());
        if (!strToKey.containsKey(name)) {
            strToKey.put(name, key);
        }
        if (!(keyToStr = this.keyToElem.computeIfAbsent(figure, k -> new HashMap())).containsKey(key)) {
            keyToStr.put(key, name);
        }
    }

    public void addSkipAttribute(Class<? extends Figure> figure, String attributeName) {
        HashSet set = this.skipAttributes.computeIfAbsent(attributeName, k -> new HashSet());
        set.add(figure);
    }

    public void addSkipElement(String elementName) {
        this.skipElements.add(elementName);
    }

    public void addSkipFigure(Class<? extends Figure> figure) {
        this.skipFigures.add(figure);
    }

    public void checkConverters(boolean throwException, Consumer<String> logger) throws IllegalStateException {
        for (HashMap<MapAccessor<?>, String> map : this.keyToAttr.values()) {
            for (MapAccessor<?> k : map.keySet()) {
                Type fullValueType = k.getValueType();
                if (k.isTransient() || this.keyValueToXML.containsKey(k) || this.valueToXML.containsKey(fullValueType)) continue;
                String msg = String.valueOf(this.getClass()) + " can not convert " + String.valueOf(fullValueType) + " to XML for key " + String.valueOf(k) + ".";
                if (throwException) {
                    throw new IllegalStateException(msg);
                }
                logger.accept(msg);
            }
        }
    }

    public void clearAttributeMap() {
        this.attrToKey.clear();
        this.keyToAttr.clear();
    }

    public void clearElementMap() {
        this.attrToKey.clear();
        this.keyToAttr.clear();
    }

    @Override
    public MapAccessor<?> getKeyByElementName(Figure f, String elementName) throws IOException {
        HashMap<String, MapAccessor<?>> strToKey = this.elemToKey.get(f.getClass());
        if (strToKey == null || !strToKey.containsKey(elementName)) {
            throw new IOException("no mapping for attribute " + elementName + " in figure " + String.valueOf(f.getClass()));
        }
        return strToKey.get(elementName);
    }

    @Override
    public Set<MapAccessor<?>> figureAttributeKeys(Figure f) {
        Set keys = this.figureAttributeKeys.get(f.getClass());
        return keys == null ? Collections.emptySet() : keys;
    }

    @Override
    public Set<MapAccessor<?>> figureNodeListKeys(Figure f) {
        Set keys = this.figureNodeListKeys.get(f.getClass());
        return keys == null ? Collections.emptySet() : keys;
    }

    @Override
    public @Nullable String getElementNameByFigure(Figure f) throws IOException {
        if (!this.figureToName.containsKey(f.getClass())) {
            if (this.skipFigures.contains(f.getClass())) {
                return null;
            }
            throw new IOException("no mapping for figure " + String.valueOf(f.getClass()));
        }
        return this.figureToName.get(f.getClass());
    }

    @Override
    public <T> T getDefaultValue(Figure f, MapAccessor<T> key) {
        FigureAccessorKey<T> k = new FigureAccessorKey<T>(f.getClass(), key);
        if (this.defaultValueMap.containsKey(k)) {
            Object defaultValue = this.defaultValueMap.get(k);
            return (T)defaultValue;
        }
        return (T)key.getDefaultValue();
    }

    public @Nullable IdFactory getIdFactory() {
        return this.idFactory;
    }

    public void setIdFactory(@Nullable IdFactory idFactory) {
        this.idFactory = idFactory;
    }

    @Override
    public String getObjectIdAttribute() {
        return this.objectIdAttribute;
    }

    public void setObjectIdAttribute(String newValue) {
        this.objectIdAttribute = newValue;
    }

    @Override
    public <T> boolean isDefaultValue(Figure f, MapAccessor<T> key, @Nullable T value) {
        Object defaultValue;
        FigureAccessorKey<T> k = new FigureAccessorKey<T>(f.getClass(), key);
        if (this.defaultValueMap.containsKey(k)) {
            Object object = defaultValue = this.defaultValueMap.get(k);
        } else {
            defaultValue = key.getDefaultValue();
        }
        return Objects.equals(defaultValue, value);
    }

    @Override
    public String getElementNameByKey(Figure f, MapAccessor<?> key) throws IOException {
        HashMap<MapAccessor<?>, String> keyToStr = null;
        if (this.keyToElem.containsKey(f.getClass())) {
            keyToStr = this.keyToElem.get(f.getClass());
        }
        if (keyToStr == null || !keyToStr.containsKey(key)) {
            throw new IOException("no mapping for key " + String.valueOf(key) + " in figure " + String.valueOf(f.getClass()));
        }
        return keyToStr.get(key);
    }

    @Override
    public String getAttributeNameByKey(Figure f, MapAccessor<?> key) throws IOException {
        HashMap<MapAccessor<?>, String> keyToStr = null;
        if (this.keyToAttr.containsKey(f.getClass())) {
            keyToStr = this.keyToAttr.get(f.getClass());
        }
        if (keyToStr == null || !keyToStr.containsKey(key)) {
            throw new IOException("no mapping for key " + String.valueOf(key) + " in figure " + String.valueOf(f.getClass()));
        }
        return keyToStr.get(key);
    }

    @Override
    public Figure createFigureByElementName(String elementName) throws IOException {
        Supplier<Figure> supplier = this.nameToFigure.get(elementName);
        if (supplier == null) {
            throw new IOException("no mapping for element " + elementName);
        }
        return supplier.get();
    }

    @Override
    public @Nullable MapAccessor<?> getKeyByAttributeName(Figure f, String attributeName) {
        Set set;
        HashMap<String, MapAccessor<?>> strToKey = this.attrToKey.get(f.getClass());
        if (!(strToKey != null && strToKey.containsKey(attributeName) || (set = (Set)this.skipAttributes.get(attributeName)) != null && set.contains(f.getClass()))) {
            LOGGER.warning("no mapping for attribute " + attributeName + " in figure " + String.valueOf(f.getClass()));
            return null;
        }
        return strToKey.get(attributeName);
    }

    @Override
    public <T> T nodeListToValue(MapAccessor<T> key, List<Node> nodeList) {
        if (key.getValueType() == String.class) {
            StringBuilder buf = new StringBuilder();
            for (Node node : nodeList) {
                if (node.getNodeType() != 3) continue;
                buf.append(node.getNodeValue());
            }
            String temp = buf.toString();
            return (T)temp;
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeKey(MapAccessor<?> key) {
        for (Map.Entry<Class<Figure>, HashMap<String, MapAccessor<?>>> entry : this.attrToKey.entrySet()) {
            for (Map.Entry<String, MapAccessor<?>> entry2 : new ArrayList(entry.getValue().entrySet())) {
                if (entry2.getValue() != key) continue;
                entry.getValue().remove(entry2.getKey());
            }
        }
        for (Map.Entry<Class<? extends Figure>, HashMap<String, Object>> entry : this.keyToAttr.entrySet()) {
            entry.getValue().remove(key);
        }
        for (Map.Entry<Class<? extends Figure>, HashMap<String, Object>> entry : this.elemToKey.entrySet()) {
            for (Map.Entry<String, Object> entry3 : new ArrayList<Map.Entry<String, Object>>(entry.getValue().entrySet())) {
                if (entry3.getValue() != key) continue;
                entry.getValue().remove(entry3.getKey());
            }
        }
        for (Map.Entry<Class<? extends Figure>, HashMap<String, Object>> entry : this.keyToElem.entrySet()) {
            entry.getValue().remove(key);
        }
        for (Map.Entry<Class<? extends Figure>, Cloneable> entry : this.figureAttributeKeys.entrySet()) {
            ((HashSet)entry.getValue()).remove(key);
        }
        for (Map.Entry<Class<? extends Figure>, Cloneable> entry : this.figureNodeListKeys.entrySet()) {
            ((HashSet)entry.getValue()).remove(key);
        }
    }

    @Override
    public <T> boolean needsIdResolver(MapAccessor<T> key) throws IOException {
        return this.getConverter(key).needsIdResolver();
    }

    @Override
    public <T> T stringToValue(MapAccessor<T> key, String string) throws IOException {
        try {
            Converter<T> converter = this.getConverter(key);
            return (T)converter.fromString((CharSequence)string, (IdResolver)this.idFactory);
        }
        catch (ParseException ex) {
            throw new IOException(String.valueOf(ex) + "\nstring: \"" + string + "\"", ex);
        }
    }

    protected <T> Converter<T> getConverter(MapAccessor<T> key) throws IOException {
        Converter<?> converter;
        Converter<?> converterFromKey = this.keyValueFromXML.get(key);
        if (converterFromKey != null) {
            Converter<?> converter2 = converter = converterFromKey;
        } else {
            converter = this.valueFromXML.get(key.getValueType());
            Converter<?> converter3 = converter;
        }
        if (converter == null) {
            throw new IOException("no converter for key \"" + String.valueOf(key) + "\" with attribute type " + String.valueOf(key.getValueType()));
        }
        return converter;
    }

    @Override
    public void valueToNodeList(MapAccessor<?> key, Object value, XMLStreamWriter w) throws XMLStreamException {
        if (key.getValueType() != String.class) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
        w.writeCharacters((String)value);
    }

    @Override
    public <T> String valueToString(MapAccessor<T> key, T value) throws IOException {
        return this.getConverter(key).toString((IdSupplier)this.idFactory, value);
    }

    private record FigureAccessorKey<T>(Class<? extends Figure> figure, MapAccessor<T> acc) {
        @Override
        public String toString() {
            return "FigureAccessorKey[figure=" + String.valueOf(this.figure) + ", acc=" + String.valueOf(this.acc) + "]";
        }
    }
}

