/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javafx.application.Platform;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.input.DataFormat;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Transform;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Page;
import org.jhotdraw8.draw.figure.PageFigure;
import org.jhotdraw8.draw.figure.Slice;
import org.jhotdraw8.draw.input.ClipboardOutputFormat;
import org.jhotdraw8.draw.io.AbstractExportOutputFormat;
import org.jhotdraw8.draw.io.OutputFormat;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.RenderingIntent;
import org.jhotdraw8.draw.render.SimpleDrawingRenderer;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class BitmapExportOutputFormat
extends AbstractExportOutputFormat
implements ClipboardOutputFormat,
OutputFormat {
    private static final double INCH_2_MM = 25.4;
    public static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final String PNG_MIME_TYPE = "image/png";

    private WritableImage doRenderImage(Figure slice, Node node, Bounds bounds, double dpi) {
        NamedCssColor color;
        SnapshotParameters parameters = new SnapshotParameters();
        double scale = dpi / (Double)RenderContext.DPI.getDefaultValueNonNull();
        parameters.setTransform(FXTransforms.concat((Transform[])new Transform[]{Transform.scale((double)scale, (double)scale), slice.getWorldToLocal()}));
        Drawing drawing = slice instanceof Drawing ? (Drawing)slice : slice.getDrawing();
        CssColor cssColor = color = drawing != null ? (CssColor)drawing.get((MapAccessor)Drawing.BACKGROUND) : NamedCssColor.WHITE;
        if (color != null) {
            parameters.setFill((Paint)color.getColor());
        }
        double x = bounds.getMinX() * scale;
        double y = bounds.getMinY() * scale;
        double width = bounds.getWidth() * scale;
        double height = bounds.getHeight() * scale;
        parameters.setViewport(new Rectangle2D(x, y, width, height));
        return node.snapshot(parameters, null);
    }

    @Override
    protected String getExtension() {
        return "png";
    }

    @Override
    protected boolean isResolutionIndependent() {
        return false;
    }

    private WritableImage renderImage(Drawing drawing, Collection<Figure> selection, double dpi) throws IOException {
        HashMap hints = new HashMap();
        RenderContext.RENDERING_INTENT.put(hints, (Object)RenderingIntent.EXPORT);
        RenderContext.DPI.put(hints, (Object)dpi);
        Node node = SimpleDrawingRenderer.toNode(drawing, selection, hints);
        Bounds selectionBounds = Figure.visualBounds(selection);
        Bounds bounds = selectionBounds == null ? new BoundingBox(0.0, 0.0, 640.0, 480.0) : selectionBounds;
        return this.renderImageOnApplicationThread(drawing, dpi, node, bounds);
    }

    private WritableImage renderImageOnApplicationThread(Figure figure, double dpi, Node node, Bounds bounds) throws IOException {
        if (!Platform.isFxApplicationThread()) {
            CompletableFuture<WritableImage> future = CompletableFuture.supplyAsync(() -> this.doRenderImage(figure, node, bounds, dpi), Platform::runLater);
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new IOException(ex);
            }
        }
        return this.doRenderImage(figure, node, bounds, dpi);
    }

    private void setDPI(IIOMetadata metadata, double dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = dpi / 25.4;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("Dimension");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    @Override
    public void write(Map<DataFormat, Object> out, Drawing drawing, Collection<Figure> selection) throws IOException {
        WritableImage image = this.renderImage(drawing, selection, (Double)EXPORT_DRAWING_DPI_KEY.getNonNull(this.getOptions()));
        out.put(DataFormat.IMAGE, image);
    }

    @Override
    public void write(OutputStream out, @Nullable URI documentHome, Drawing drawing, WorkState<Void> workState) throws IOException {
        WritableImage writableImage = this.renderImage(drawing, Collections.singleton(drawing), (Double)EXPORT_DRAWING_DPI_KEY.getNonNull(this.getOptions()));
        this.writeImage(out, writableImage, (Double)EXPORT_DRAWING_DPI_KEY.getNonNull(this.getOptions()));
    }

    @Override
    public void write(Path file, Drawing drawing, WorkState<Void> workState) throws IOException {
        if (this.isExportDrawing()) {
            OutputFormat.super.write(file, drawing, workState);
        }
        if (this.isExportSlices()) {
            this.writeSlices(file.getParent(), drawing);
        }
        if (this.isExportPages()) {
            String basename = file.getFileName().toString();
            int p = basename.lastIndexOf(46);
            if (p != -1) {
                basename = basename.substring(0, p);
            }
            this.writePages(file.getParent(), basename, drawing);
        }
    }

    private void writeImage(OutputStream out, WritableImage writableImage, double dpi) throws IOException {
        BufferedImage image = BitmapExportOutputFormat.fromFXImage((Image)writableImage, null);
        if (image == null) {
            throw new IOException("Could not convert the JavaFX image to AWT.");
        }
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
        while (iw.hasNext()) {
            ImageWriter writer = iw.next();
            ImageWriteParam writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
            IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            this.setDPI(metadata, dpi);
            try (MemoryCacheImageOutputStream output = new MemoryCacheImageOutputStream(out);){
                writer.setOutput(output);
                writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                break;
            }
        }
    }

    @Override
    protected void writePage(Path file, Page page, Node node, int pageCount, int pageNumber, int internalPageNumber) throws IOException {
        CssSize pw = (CssSize)page.getNonNull((NonNullMapAccessor)PageFigure.PAPER_WIDTH);
        double paperWidth = pw.getConvertedValue();
        Bounds pageBounds = page.getPageBounds(internalPageNumber);
        double factor = paperWidth / pageBounds.getWidth();
        double dpi = (Double)EXPORT_PAGES_DPI_KEY.getNonNull(this.getOptions());
        WritableImage image = this.renderImageOnApplicationThread(page, dpi * factor, node, pageBounds);
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            this.writeImage(out, image, dpi);
        }
    }

    @Override
    protected boolean writeSlice(Path file, Slice slice, Node node, double dpi) throws IOException {
        WritableImage image = this.renderImageOnApplicationThread(slice, dpi, node, slice.getLayoutBounds());
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(file, new OpenOption[0]));){
            this.writeImage(out, image, dpi);
        }
        return false;
    }

    public static @Nullable BufferedImage fromFXImage(Image img, @Nullable BufferedImage bimg) {
        PixelReader pr = img.getPixelReader();
        if (pr == null) {
            return null;
        }
        int iw = (int)img.getWidth();
        int ih = (int)img.getHeight();
        PixelFormat fxFormat = pr.getPixelFormat();
        boolean srcPixelsAreOpaque = BitmapExportOutputFormat.isSrcPixelsAreOpaque(bimg, pr, iw, ih, fxFormat);
        int prefBimgType = BitmapExportOutputFormat.getBestBufferedImageType(pr.getPixelFormat(), bimg, srcPixelsAreOpaque);
        if (bimg != null) {
            int bw = bimg.getWidth();
            int bh = bimg.getHeight();
            if (bw < iw || bh < ih || bimg.getType() != prefBimgType) {
                bimg = null;
            } else if (iw < bw || ih < bh) {
                Graphics2D g2d = bimg.createGraphics();
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(0, 0, bw, bh);
                g2d.dispose();
            }
        }
        if (bimg == null) {
            bimg = new BufferedImage(iw, ih, prefBimgType);
        }
        DataBufferInt db = (DataBufferInt)bimg.getRaster().getDataBuffer();
        int[] data = db.getData();
        int offset = bimg.getRaster().getDataBuffer().getOffset();
        int scan = 0;
        SampleModel sm = bimg.getRaster().getSampleModel();
        if (sm instanceof SinglePixelPackedSampleModel) {
            scan = ((SinglePixelPackedSampleModel)sm).getScanlineStride();
        }
        WritablePixelFormat<IntBuffer> pf = BitmapExportOutputFormat.getAssociatedPixelFormat(bimg);
        pr.getPixels(0, 0, iw, ih, pf, data, offset, scan);
        return bimg;
    }

    private static boolean isSrcPixelsAreOpaque(BufferedImage bimg, PixelReader pr, int iw, int ih, PixelFormat<?> fxFormat) {
        boolean srcPixelsAreOpaque = false;
        switch (fxFormat.getType()) {
            case INT_ARGB_PRE: 
            case INT_ARGB: 
            case BYTE_BGRA_PRE: 
            case BYTE_BGRA: {
                if (bimg == null || bimg.getType() != 4 && bimg.getType() != 1) break;
                srcPixelsAreOpaque = BitmapExportOutputFormat.checkFXImageOpaque(pr, iw, ih);
                break;
            }
            case BYTE_RGB: {
                srcPixelsAreOpaque = true;
            }
        }
        return srcPixelsAreOpaque;
    }

    private static boolean checkFXImageOpaque(PixelReader pr, int iw, int ih) {
        for (int y = 0; y < ih; ++y) {
            for (int x = 0; x < iw; ++x) {
                int argb = pr.getArgb(x, y);
                if ((argb & 0xFF000000) == -16777216) continue;
                return false;
            }
        }
        return true;
    }

    static int getBestBufferedImageType(PixelFormat<?> fxFormat, @Nullable BufferedImage bimg, boolean isOpaque) {
        int bimgType;
        if (bimg != null && ((bimgType = bimg.getType()) == 2 || bimgType == 3 || isOpaque && (bimgType == 4 || bimgType == 1))) {
            return bimgType;
        }
        return switch (fxFormat.getType()) {
            default -> 3;
            case PixelFormat.Type.INT_ARGB, PixelFormat.Type.BYTE_BGRA -> 2;
            case PixelFormat.Type.BYTE_RGB -> 1;
            case PixelFormat.Type.BYTE_INDEXED -> fxFormat.isPremultiplied() ? 3 : 2;
        };
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bimg) {
        return switch (bimg.getType()) {
            case 1, 3 -> PixelFormat.getIntArgbPreInstance();
            case 2 -> PixelFormat.getIntArgbInstance();
            default -> throw new InternalError("Failed to validate BufferedImage type");
        };
    }
}

