/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamException;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public interface InputFormat {
    public void setOptions(ImmutableMap<Key<?>, Object> var1);

    public ImmutableMap<Key<?>, Object> getOptions();

    default public Figure read(URI uri, @Nullable Drawing drawing, WorkState<Void> workState) throws IOException {
        return this.read(Paths.get(uri), drawing, workState);
    }

    default public Figure read(Path file, @Nullable Drawing drawing, WorkState<Void> workState) throws IOException {
        Figure figure;
        URI documentHome = file.getParent() == null ? FileSystems.getDefault().getPath(System.getProperty("user.home"), new String[0]).toUri() : file.getParent().toUri();
        BufferedInputStream in = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        try {
            figure = this.read(in, drawing, documentHome, workState);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                XMLStreamException xse;
                Throwable throwable3 = e.getCause();
                if (throwable3 instanceof XMLStreamException && (xse = (XMLStreamException)throwable3).getLocation() != null && xse.getLocation().getSystemId() != null) {
                    throw new IOException("Error reading " + xse.getLocation().getSystemId(), xse);
                }
                throw new IOException("Error reading " + String.valueOf(file.toAbsolutePath().toUri()), e);
            }
        }
        in.close();
        return figure;
    }

    public Figure read(InputStream var1, Drawing var2, URI var3, WorkState<Void> var4) throws IOException;
}

