/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.IOException;
import java.nio.file.Path;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.PrinterJob;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.draw.css.value.CssDimension2D;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Page;
import org.jhotdraw8.draw.figure.PageFigure;
import org.jhotdraw8.draw.figure.Slice;
import org.jhotdraw8.draw.io.AbstractExportOutputFormat;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;

public class PrinterExportFormat
extends AbstractExportOutputFormat {
    private static final double INCH_2_MM = 25.4;
    private PrinterJob job;

    @Override
    protected String getExtension() {
        return "png";
    }

    @Override
    protected boolean isResolutionIndependent() {
        return false;
    }

    public Paper findPaper(CssDimension2D paperSize) {
        DefaultUnitConverter uc = new DefaultUnitConverter(72.0);
        double w = uc.convert(paperSize.getWidth(), "pt");
        double h = uc.convert(paperSize.getHeight(), "pt");
        for (Paper paper : this.job.getPrinter().getPrinterAttributes().getSupportedPapers()) {
            if (!(Math.abs(paper.getWidth() - w) < 1.0 && Math.abs(paper.getHeight() - h) < 1.0) && (!(Math.abs(paper.getWidth() - h) < 1.0) || !(Math.abs(paper.getHeight() - w) < 1.0))) continue;
            return paper;
        }
        return Paper.A4;
    }

    private void printSlice(CssDimension2D pageSize, Figure slice, Bounds viewportBounds, Node node, double dpi) {
        double ph;
        double pw;
        Paper paper = this.findPaper(pageSize);
        Dimension2D psize = pageSize.getConvertedValue();
        PageLayout pl = this.job.getPrinter().createPageLayout(paper, psize.getWidth() <= psize.getHeight() ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE, 0.0, 0.0, 0.0, 0.0);
        this.job.getJobSettings().setPageLayout(pl);
        paper = pl.getPaper();
        if (paper == null) {
            paper = Paper.A4;
        }
        if (pl.getPageOrientation() == PageOrientation.LANDSCAPE) {
            pw = paper.getHeight();
            ph = paper.getWidth();
        } else {
            pw = paper.getWidth();
            ph = paper.getHeight();
        }
        double paperAspect = paper.getWidth() / paper.getHeight();
        double pageAspect = viewportBounds.getWidth() / viewportBounds.getHeight();
        double scaleFactor = paperAspect < pageAspect ? ph / viewportBounds.getHeight() : pw / viewportBounds.getWidth();
        Group oldParent = node.getParent() instanceof Group ? (Group)node.getParent() : null;
        int index = -1;
        if (oldParent != null) {
            index = oldParent.getChildren().indexOf((Object)node);
            oldParent.getChildren().remove(index);
        }
        Group printParent = new Group();
        printParent.getChildren().add((Object)node);
        printParent.getTransforms().addAll((Object[])new Transform[]{new Translate(-pl.getLeftMargin(), -pl.getTopMargin()), new Scale(scaleFactor, scaleFactor), new Translate(-viewportBounds.getMinX(), -viewportBounds.getMinY())});
        if (slice.getWorldToLocal() != null) {
            printParent.getTransforms().add((Object)slice.getWorldToLocal());
        }
        Group printNode = new Group();
        printNode.getChildren().addAll((Object[])new Node[]{printParent});
        this.job.printPage((Node)printNode);
        printParent.getChildren().clear();
        if (oldParent != null) {
            oldParent.getChildren().add(index, (Object)node);
        }
    }

    private void setDPI(IIOMetadata metadata, double dpi) throws IIOInvalidTreeException {
        double dotsPerMilli = dpi / 25.4;
        IIOMetadataNode horiz = new IIOMetadataNode("HorizontalPixelSize");
        horiz.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode vert = new IIOMetadataNode("VerticalPixelSize");
        vert.setAttribute("value", Double.toString(dotsPerMilli));
        IIOMetadataNode dim = new IIOMetadataNode("CssSize");
        dim.appendChild(horiz);
        dim.appendChild(vert);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(dim);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    @Override
    protected void writePage(Path file, Page page, Node node, int pageCount, int pageNumber, int internalPageNumber) throws IOException {
        CssSize pw = (CssSize)page.get((MapAccessor)PageFigure.PAPER_WIDTH);
        double paperWidth = pw.getConvertedValue();
        Bounds pageBounds = page.getPageBounds(internalPageNumber);
        double factor = paperWidth / pageBounds.getWidth();
        this.printSlice((CssDimension2D)page.get((MapAccessor)PageFigure.PAPER_SIZE), page, pageBounds, node, (Double)EXPORT_PAGES_DPI_KEY.get(this.getOptions()) * factor);
    }

    @Override
    protected boolean writeSlice(Path file, Slice slice, Node node, double dpi) throws IOException {
        this.printSlice(null, slice, slice.getLayoutBounds(), node, dpi);
        return false;
    }

    public void print(PrinterJob job, Drawing drawing) throws IOException {
        this.job = job;
        try {
            this.writePages(null, null, drawing);
            this.writeSlices(null, drawing);
        }
        finally {
            job = null;
        }
    }
}

