/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.FutureTask;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jhotdraw8.base.converter.IdFactory;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.GroupFigure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.StyleableFigure;
import org.jhotdraw8.draw.input.ClipboardInputFormat;
import org.jhotdraw8.draw.io.AbstractInputFormat;
import org.jhotdraw8.draw.io.FigureFactory;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.fxbase.concurrent.SimpleWorkState;
import org.jhotdraw8.fxbase.concurrent.WorkState;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.VectorList;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.xml.XmlUtil;
import org.jspecify.annotations.Nullable;

public class SimpleXmlReader
extends AbstractInputFormat
implements ClipboardInputFormat {
    private static final Pattern hrefPattern = Pattern.compile("\\s+href=\"([^\"]*?)\"");
    private final IdFactory idFactory;
    private @Nullable String namespaceURI;
    private FigureFactory figureFactory;
    private final String idAttribute = "id";
    private Supplier<Layer> layerFactory;

    public SimpleXmlReader(FigureFactory figureFactory, IdFactory idFactory, @Nullable String namespaceURI) {
        this.idFactory = idFactory;
        this.figureFactory = figureFactory;
        this.namespaceURI = namespaceURI;
    }

    private Figure createFigure(XMLStreamReader r, Deque<Figure> stack) throws IOException {
        Figure figure;
        try {
            figure = this.figureFactory.createFigureByElementName(r.getLocalName());
        }
        catch (IOException e) {
            throw new IOException("Cannot create figure for element <" + r.getLocalName() + "> at line " + r.getLocation().getLineNumber() + ", col " + r.getLocation().getColumnNumber(), e);
        }
        if (stack.isEmpty()) {
            stack.addFirst(figure);
        } else {
            Figure parent = stack.peek();
            if (!figure.isSuitableParent(parent) || !parent.isSuitableChild(figure)) {
                throw new IOException("Cannot add figure to parent in element <" + r.getLocalName() + "> at line " + r.getLocation().getLineNumber() + ", col " + r.getLocation().getColumnNumber());
            }
            parent.getChildren().add((Object)figure);
        }
        stack.addFirst(figure);
        return figure;
    }

    private DataFormat getDataFormat() {
        String mimeType = "application/xml";
        DataFormat df = DataFormat.lookupMimeType((String)mimeType);
        if (df == null) {
            df = new DataFormat(new String[]{mimeType});
        }
        return df;
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public Supplier<Layer> getLayerFactory() {
        return this.layerFactory;
    }

    public void setLayerFactory(Supplier<Layer> layerFactory) {
        this.layerFactory = layerFactory;
    }

    @Override
    public Figure read(InputStream in, @Nullable Drawing drawing, @Nullable URI documentHome, WorkState<Void> workState) throws IOException {
        return this.read((AutoCloseable)in, drawing, documentHome, workState);
    }

    private Deque<Figure> doRead(AutoCloseable in) throws IOException {
        ArrayDeque<Figure> stack = new ArrayDeque<Figure>();
        ArrayList<Runnable> secondPass = new ArrayList<Runnable>();
        ArrayList<Runnable> parallelPass = new ArrayList<Runnable>();
        ArrayList<FutureTask<Void>> futures = new ArrayList<FutureTask<Void>>();
        ArrayList<Consumer<Figure>> processingInstructions = new ArrayList<Consumer<Figure>>();
        try {
            StreamSource streamSource;
            if (in instanceof InputStream) {
                InputStream inputStream = (InputStream)in;
                streamSource = new StreamSource(inputStream);
            } else {
                streamSource = new StreamSource((Reader)in);
            }
            XMLStreamReader xmlStreamReader = XmlUtil.streamReader((Source)streamSource);
            while (xmlStreamReader.hasNext()) {
                this.readNode(xmlStreamReader, xmlStreamReader.next(), stack, processingInstructions, secondPass, parallelPass, futures);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        if (stack.size() != 1) {
            throw new IOException("The file does not contain a root element in namespace=\"" + this.namespaceURI + "\".");
        }
        for (Consumer consumer : processingInstructions) {
            consumer.accept((Figure)stack.getFirst());
        }
        this.forkParallelPass(futures, parallelPass);
        try {
            secondPass.parallelStream().forEach(Runnable::run);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        try {
            for (FutureTask futureTask : futures) {
                futureTask.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        return stack;
    }

    public @Nullable Figure read(Reader in, @Nullable Drawing drawing, @Nullable URI documentHome, WorkState<Void> workState) throws IOException {
        return this.read((AutoCloseable)in, drawing, documentHome, workState);
    }

    private Figure read(AutoCloseable in, @Nullable Drawing drawing, @Nullable URI documentHome, WorkState<Void> workState) throws IOException {
        Figure figure;
        workState.updateProgress(0.0);
        this.idFactory.setDocumentHome(documentHome);
        Deque<Figure> stack = this.doRead(in);
        Figure figure2 = figure = stack.isEmpty() ? null : stack.getFirst();
        if (figure == null) {
            throw new IOException("Input file is empty.");
        }
        if (figure instanceof Drawing) {
            figure.set((MapAccessor)Drawing.DOCUMENT_HOME, documentHome);
        }
        workState.updateProgress(1.0);
        return figure;
    }

    public SequencedSet<Figure> read(Clipboard clipboard, DrawingModel model, Drawing drawing, @Nullable Figure parent) throws IOException {
        Object content = clipboard.getContent(this.getDataFormat());
        if (content instanceof String) {
            LinkedHashSet<Figure> figures = new LinkedHashSet<Figure>();
            Figure newDrawing = this.read(new StringReader((String)content), null, null, (WorkState<Void>)new SimpleWorkState());
            if (newDrawing == null) {
                return figures;
            }
            this.idFactory.reset();
            this.idFactory.setDocumentHome(null);
            for (Figure f : drawing.preorderIterable()) {
                this.idFactory.createId((Object)f);
            }
            if (parent == null) {
                parent = this.layerFactory.get();
            }
            if (parent.getDrawing() != drawing) {
                model.addChildTo(parent, drawing);
            }
            for (Figure f : new ArrayList<Figure>((Collection<Figure>)newDrawing.getChildren())) {
                figures.add(f);
                newDrawing.removeChild(f);
                String id = this.idFactory.createId((Object)f);
                f.set((MapAccessor)StyleableFigure.ID, id);
                if (f instanceof Layer) {
                    model.addChildTo(f, drawing);
                    continue;
                }
                model.addChildTo(f, parent);
            }
            return figures;
        }
        throw new IOException("no data found");
    }

    private void readAttributes(XMLStreamReader r, Figure figure, List<Runnable> secondPass, List<Runnable> parallelPass) throws IOException {
        int n = r.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String ns = r.getAttributeNamespace(i);
            if (this.namespaceURI != null && ns != null && !this.namespaceURI.equals(ns)) continue;
            String attributeLocalName = r.getAttributeLocalName(i);
            String attributeValue = r.getAttributeValue(i);
            Location location = r.getLocation();
            if ("id".equals(attributeLocalName)) {
                this.idFactory.putIdToObject(attributeValue, (Object)figure);
                this.setId(figure, attributeValue);
                continue;
            }
            MapAccessor<?> key = this.figureFactory.getKeyByAttributeName(figure, attributeLocalName);
            if (key == null) {
                throw new IOException("Unsupported attribute \"" + attributeLocalName + "\" at line " + location.getLineNumber() + ", col " + location.getColumnNumber());
            }
            List<Runnable> pass = this.figureFactory.needsIdResolver(key) ? secondPass : parallelPass;
            pass.add(() -> {
                try {
                    figure.set(key, this.figureFactory.stringToValue(key, attributeValue));
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading attribute" + attributeLocalName + "\" at line " + location.getLineNumber() + ", col " + location.getColumnNumber(), e);
                }
            });
        }
    }

    private void readEndElement(XMLStreamReader r, Deque<Figure> stack) {
        stack.removeFirst();
    }

    private void readNode(XMLStreamReader r, int next, Deque<Figure> stack, List<Consumer<Figure>> processingInstructions, List<Runnable> secondPass, List<Runnable> parallelPass, List<FutureTask<Void>> futures) throws IOException {
        switch (next) {
            case 1: {
                this.readStartElement(r, stack, secondPass, parallelPass);
                break;
            }
            case 2: {
                this.readEndElement(r, stack);
                break;
            }
            case 3: {
                Consumer<Figure> processingInstruction = this.readProcessingInstruction(r, stack, secondPass);
                if (processingInstruction == null) break;
                processingInstructions.add(processingInstruction);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            default: {
                throw new IOException("unsupported XMLStream event: " + next);
            }
        }
        if (parallelPass.size() > 1000) {
            ArrayList<Runnable> runParallel = new ArrayList<Runnable>(parallelPass);
            parallelPass.clear();
            this.forkParallelPass(futures, runParallel);
        }
    }

    private void forkParallelPass(List<FutureTask<Void>> futures, List<Runnable> runParallel) {
        FutureTask<Void> task = new FutureTask<Void>(() -> {
            for (Runnable runner : runParallel) {
                runner.run();
            }
            return null;
        });
        if (ForkJoinPool.getCommonPoolParallelism() < 2) {
            task.run();
        } else {
            ForkJoinPool.commonPool().execute(task);
        }
        futures.add(task);
    }

    private @Nullable Consumer<Figure> readProcessingInstruction(XMLStreamReader r, Deque<Figure> stack, List<Runnable> secondPass) {
        if (this.figureFactory.getStylesheetsKey() != null) {
            String piTarget = r.getPITarget();
            String piData = r.getPIData();
            if ("xml-stylesheet".equals(piTarget) && piData != null) {
                return drawing -> {
                    Matcher m = hrefPattern.matcher(piData);
                    if (m.find()) {
                        String href = m.group(1);
                        URI uri = URI.create(href);
                        uri = this.idFactory.absolutize(uri);
                        ImmutableList listOrNull = (ImmutableList)drawing.get(this.figureFactory.getStylesheetsKey());
                        ArrayList<URI> stylesheets = listOrNull == null ? new ArrayList<URI>() : new ArrayList(listOrNull.asList());
                        stylesheets.add(uri);
                        drawing.set(this.figureFactory.getStylesheetsKey(), VectorList.copyOf(stylesheets));
                    }
                };
            }
        }
        return null;
    }

    private void readStartElement(XMLStreamReader r, Deque<Figure> stack, List<Runnable> secondPass, List<Runnable> parallelPass) throws IOException {
        if (this.namespaceURI != null && !this.namespaceURI.equals(r.getNamespaceURI())) {
            stack.push(new GroupFigure());
            return;
        }
        Figure figure = this.createFigure(r, stack);
        this.readAttributes(r, figure, secondPass, parallelPass);
    }

    public void setFigureFactory(FigureFactory figureFactory) {
        this.figureFactory = figureFactory;
    }

    protected void setId(Figure figure, String id) {
        figure.set((MapAccessor)StyleableFigure.ID, id);
    }

    public void setNamespaceURI(@Nullable String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }
}

