/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.converter.InsetsCssConverter;
import org.jhotdraw8.draw.css.value.CssInsets;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public class CssInsetsStyleableMapAccessor
extends AbstractStyleableMapAccessor<CssInsets>
implements NonNullMapAccessor<CssInsets> {
    private final NonNullMapAccessor<CssSize> topKey;
    private final NonNullMapAccessor<CssSize> rightKey;
    private final NonNullMapAccessor<CssSize> bottomKey;
    private final NonNullMapAccessor<CssSize> leftKey;
    private final Converter<CssInsets> converter = new InsetsCssConverter(false);

    public CssInsetsStyleableMapAccessor(String name, NonNullMapAccessor<CssSize> topKey, NonNullMapAccessor<CssSize> rightKey, NonNullMapAccessor<CssSize> bottomKey, NonNullMapAccessor<CssSize> leftKey) {
        super(name, CssInsets.class, (MapAccessor<?>[])new NonNullMapAccessor[]{topKey, rightKey, bottomKey, leftKey}, new CssInsets((CssSize)topKey.getDefaultValue(), (CssSize)rightKey.getDefaultValue(), (CssSize)bottomKey.getDefaultValue(), (CssSize)leftKey.getDefaultValue()));
        this.topKey = topKey;
        this.rightKey = rightKey;
        this.bottomKey = bottomKey;
        this.leftKey = leftKey;
    }

    public Converter<CssInsets> getCssConverter() {
        return this.converter;
    }

    public @Nullable CssInsets get(Map<? super Key<?>, Object> a) {
        CssSize top = (CssSize)this.topKey.get(a);
        CssSize right = (CssSize)this.rightKey.get(a);
        CssSize bottom = (CssSize)this.bottomKey.get(a);
        CssSize left = (CssSize)this.leftKey.get(a);
        if (top == null || right == null || bottom == null | left == null) {
            return null;
        }
        return new CssInsets(top, right, bottom, left);
    }

    public void set(Map<? super Key<?>, Object> a, @Nullable CssInsets value) {
        if (value == null) {
            this.remove((Map)a);
        } else {
            this.topKey.put(a, (Object)value.getTop());
            this.rightKey.put(a, (Object)value.getRight());
            this.bottomKey.put(a, (Object)value.getBottom());
            this.leftKey.put(a, (Object)value.getLeft());
        }
    }

    public @Nullable CssInsets remove(Map<? super Key<?>, Object> a) {
        Object oldValue = this.get((Map)a);
        this.topKey.remove(a);
        this.rightKey.remove(a);
        this.bottomKey.remove(a);
        this.leftKey.remove(a);
        return oldValue;
    }

    @Override
    public ImmutableMap<Key<?>, Object> put(ImmutableMap<Key<?>, Object> a, @Nullable CssInsets value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.topKey.put(a, (Object)value.getTop());
        a = this.rightKey.put(a, (Object)value.getRight());
        a = this.bottomKey.put(a, (Object)value.getBottom());
        return this.leftKey.put(a, (Object)value.getLeft());
    }

    public ImmutableMap<Key<?>, Object> remove(ImmutableMap<Key<?>, Object> a) {
        a = this.topKey.remove(a);
        a = this.rightKey.remove(a);
        a = this.bottomKey.remove(a);
        return this.leftKey.remove(a);
    }
}

