/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Insets;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.InsetsConverter;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public class InsetsStyleableMapAccessor
extends AbstractStyleableMapAccessor<Insets> {
    private final MapAccessor<Double> topKey;
    private final MapAccessor<Double> rightKey;
    private final MapAccessor<Double> bottomKey;
    private final MapAccessor<Double> leftKey;
    private final Converter<Insets> converter = new InsetsConverter(false);

    public InsetsStyleableMapAccessor(String name, MapAccessor<Double> topKey, MapAccessor<Double> rightKey, MapAccessor<Double> bottomKey, MapAccessor<Double> leftKey) {
        super(name, Insets.class, new MapAccessor[]{topKey, rightKey, bottomKey, leftKey}, new Insets(((Double)topKey.getDefaultValue()).doubleValue(), ((Double)rightKey.getDefaultValue()).doubleValue(), ((Double)bottomKey.getDefaultValue()).doubleValue(), ((Double)leftKey.getDefaultValue()).doubleValue()));
        this.topKey = topKey;
        this.rightKey = rightKey;
        this.bottomKey = bottomKey;
        this.leftKey = leftKey;
    }

    public Insets get(Map<? super Key<?>, Object> a) {
        Double top = (Double)this.topKey.get(a);
        Double right = (Double)this.rightKey.get(a);
        Double bottom = (Double)this.bottomKey.get(a);
        Double left = (Double)this.leftKey.get(a);
        return new Insets(top == null ? 0.0 : top, right == null ? 0.0 : right, bottom == null ? 0.0 : bottom, left == null ? 0.0 : left);
    }

    public Converter<Insets> getCssConverter() {
        return this.converter;
    }

    public Insets remove(Map<? super Key<?>, Object> a) {
        Insets oldValue = this.get(a);
        this.topKey.remove(a);
        this.rightKey.remove(a);
        this.bottomKey.remove(a);
        this.leftKey.remove(a);
        return oldValue;
    }

    public void set(Map<? super Key<?>, Object> a, @Nullable Insets value) {
        if (value == null) {
            this.remove(a);
        } else {
            this.topKey.put(a, (Object)value.getTop());
            this.rightKey.put(a, (Object)value.getRight());
            this.bottomKey.put(a, (Object)value.getBottom());
            this.leftKey.put(a, (Object)value.getLeft());
        }
    }

    @Override
    public ImmutableMap<Key<?>, Object> put(ImmutableMap<Key<?>, Object> a, @Nullable Insets value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.topKey.put(a, (Object)value.getTop());
        a = this.rightKey.put(a, (Object)value.getRight());
        a = this.bottomKey.put(a, (Object)value.getBottom());
        return this.leftKey.put(a, (Object)value.getLeft());
    }

    public ImmutableMap<Key<?>, Object> remove(ImmutableMap<Key<?>, Object> a) {
        a = this.topKey.remove(a);
        a = this.rightKey.remove(a);
        a = this.bottomKey.remove(a);
        return this.leftKey.remove(a);
    }
}

