/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.geometry.Rectangle2D;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.draw.css.converter.Rectangle2DConverter;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public class Rectangle2DStyleableMapAccessor
extends AbstractStyleableMapAccessor<Rectangle2D>
implements NonNullMapAccessor<Rectangle2D> {
    private final NonNullMapAccessor<Double> xKey;
    private final NonNullMapAccessor<Double> yKey;
    private final NonNullMapAccessor<Double> widthKey;
    private final NonNullMapAccessor<Double> heightKey;
    private final Converter<Rectangle2D> converter = new Rectangle2DConverter(false);

    public Rectangle2DStyleableMapAccessor(String name, NonNullMapAccessor<Double> xKey, NonNullMapAccessor<Double> yKey, NonNullMapAccessor<Double> widthKey, NonNullMapAccessor<Double> heightKey) {
        super(name, Rectangle2D.class, (MapAccessor<?>[])new NonNullMapAccessor[]{xKey, yKey, widthKey, heightKey}, new Rectangle2D(((Double)xKey.getDefaultValueNonNull()).doubleValue(), ((Double)yKey.getDefaultValueNonNull()).doubleValue(), ((Double)widthKey.getDefaultValueNonNull()).doubleValue(), ((Double)heightKey.getDefaultValueNonNull()).doubleValue()));
        this.xKey = xKey;
        this.yKey = yKey;
        this.widthKey = widthKey;
        this.heightKey = heightKey;
    }

    public Rectangle2D get(Map<? super Key<?>, Object> a) {
        return new Rectangle2D(((Double)this.xKey.getNonNull(a)).doubleValue(), ((Double)this.yKey.getNonNull(a)).doubleValue(), Double.max(0.0, (Double)this.widthKey.getNonNull(a)), Double.max(0.0, (Double)this.heightKey.getNonNull(a)));
    }

    public Converter<Rectangle2D> getCssConverter() {
        return this.converter;
    }

    public Rectangle2D remove(Map<? super Key<?>, Object> a) {
        Rectangle2D oldValue = this.get(a);
        this.xKey.remove(a);
        this.yKey.remove(a);
        this.widthKey.remove(a);
        this.heightKey.remove(a);
        return oldValue;
    }

    public void set(Map<? super Key<?>, Object> a, @Nullable Rectangle2D value) {
        if (value == null) {
            this.remove(a);
        } else {
            this.xKey.put(a, (Object)value.getMinX());
            this.yKey.put(a, (Object)value.getMinY());
            this.widthKey.put(a, (Object)value.getWidth());
            this.heightKey.put(a, (Object)value.getHeight());
        }
    }

    @Override
    public ImmutableMap<Key<?>, Object> put(ImmutableMap<Key<?>, Object> a, @Nullable Rectangle2D value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.xKey.put(a, (Object)value.getMinX());
        a = this.yKey.put(a, (Object)value.getMinY());
        a = this.widthKey.put(a, (Object)value.getWidth());
        return this.heightKey.put(a, (Object)value.getHeight());
    }

    public ImmutableMap<Key<?>, Object> remove(ImmutableMap<Key<?>, Object> a) {
        a = this.xKey.remove(a);
        a = this.yKey.remove(a);
        a = this.widthKey.remove(a);
        return this.heightKey.remove(a);
    }
}

