/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.key;

import java.util.Map;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.converter.StrokeStyleCssConverter;
import org.jhotdraw8.draw.css.value.CssStrokeStyle;
import org.jhotdraw8.draw.key.AbstractStyleableMapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.icollection.immutable.ImmutableList;
import org.jhotdraw8.icollection.immutable.ImmutableMap;
import org.jspecify.annotations.Nullable;

public class StrokeStyleableMapAccessor
extends AbstractStyleableMapAccessor<CssStrokeStyle> {
    private final MapAccessor<CssSize> dashOffsetKey;
    private final MapAccessor<ImmutableList<CssSize>> dashArrayKey;
    private final MapAccessor<StrokeType> typeKey;
    private final MapAccessor<StrokeLineJoin> lineJoinKey;
    private final MapAccessor<StrokeLineCap> lineCapKey;
    private final MapAccessor<CssSize> miterLimitKey;
    private final Converter<CssStrokeStyle> converter = new StrokeStyleCssConverter(false);

    public StrokeStyleableMapAccessor(String name, MapAccessor<StrokeType> typeKey, MapAccessor<StrokeLineCap> lineCapKey, MapAccessor<StrokeLineJoin> lineJoinKey, MapAccessor<CssSize> miterLimitKey, MapAccessor<CssSize> dashOffsetKey, MapAccessor<ImmutableList<CssSize>> dashArrayKey) {
        super(name, CssStrokeStyle.class, new MapAccessor[]{typeKey, lineJoinKey, lineCapKey, miterLimitKey, dashOffsetKey, dashArrayKey}, new CssStrokeStyle((StrokeType)typeKey.getDefaultValue(), (StrokeLineCap)lineCapKey.getDefaultValue(), (StrokeLineJoin)lineJoinKey.getDefaultValue(), (CssSize)miterLimitKey.getDefaultValue(), (CssSize)dashOffsetKey.getDefaultValue(), (ImmutableList<CssSize>)((ImmutableList)dashArrayKey.getDefaultValue())));
        this.dashOffsetKey = dashOffsetKey;
        this.dashArrayKey = dashArrayKey;
        this.typeKey = typeKey;
        this.lineJoinKey = lineJoinKey;
        this.lineCapKey = lineCapKey;
        this.miterLimitKey = miterLimitKey;
    }

    public CssStrokeStyle get(Map<? super Key<?>, Object> a) {
        return new CssStrokeStyle((StrokeType)this.typeKey.get(a), (StrokeLineCap)this.lineCapKey.get(a), (StrokeLineJoin)this.lineJoinKey.get(a), (CssSize)this.miterLimitKey.get(a), (CssSize)this.dashOffsetKey.get(a), (ImmutableList<CssSize>)((ImmutableList)this.dashArrayKey.get(a)));
    }

    public Converter<CssStrokeStyle> getCssConverter() {
        return this.converter;
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    public CssStrokeStyle remove(Map<? super Key<?>, Object> a) {
        Object oldValue = this.get((Map)a);
        this.typeKey.remove(a);
        this.lineJoinKey.remove(a);
        this.lineCapKey.remove(a);
        this.miterLimitKey.remove(a);
        this.dashOffsetKey.remove(a);
        this.dashArrayKey.remove(a);
        return oldValue;
    }

    public void set(Map<? super Key<?>, Object> a, @Nullable CssStrokeStyle value) {
        if (value == null) {
            this.remove((Map)a);
        } else {
            this.dashOffsetKey.put(a, (Object)value.getDashOffset());
            this.dashArrayKey.put(a, value.getDashArray());
            this.typeKey.put(a, (Object)value.getType());
            this.lineJoinKey.put(a, (Object)value.getLineJoin());
            this.lineCapKey.put(a, (Object)value.getLineCap());
            this.miterLimitKey.put(a, (Object)value.getMiterLimit());
        }
    }

    @Override
    public ImmutableMap<Key<?>, Object> put(ImmutableMap<Key<?>, Object> a, @Nullable CssStrokeStyle value) {
        if (value == null) {
            return this.remove(a);
        }
        a = this.dashOffsetKey.put(a, (Object)value.getDashOffset());
        a = this.dashArrayKey.put(a, value.getDashArray());
        a = this.typeKey.put(a, (Object)value.getType());
        a = this.lineJoinKey.put(a, (Object)value.getLineJoin());
        a = this.lineCapKey.put(a, (Object)value.getLineCap());
        return this.miterLimitKey.put(a, (Object)value.getMiterLimit());
    }

    public ImmutableMap<Key<?>, Object> remove(ImmutableMap<Key<?>, Object> a) {
        a = this.typeKey.remove(a);
        a = this.lineJoinKey.remove(a);
        a = this.lineCapKey.remove(a);
        a = this.miterLimitKey.remove(a);
        a = this.dashOffsetKey.remove(a);
        return this.dashArrayKey.remove(a);
    }
}

