/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.locator;

import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.locator.AbstractLocator;
import org.jspecify.annotations.Nullable;

public class BoundsLocator
extends AbstractLocator {
    public static final BoundsLocator CENTER = new BoundsLocator(0.5, 0.5);
    public static final BoundsLocator EAST = new BoundsLocator(1.0, 0.5);
    public static final BoundsLocator NORTH = new BoundsLocator(0.5, 0.0);
    public static final BoundsLocator NORTH_EAST = new BoundsLocator(1.0, 0.0);
    public static final BoundsLocator NORTH_WEST = new BoundsLocator(0.0, 0.0);
    public static final BoundsLocator SOUTH = new BoundsLocator(0.5, 1.0);
    public static final BoundsLocator SOUTH_EAST = new BoundsLocator(1.0, 1.0);
    public static final BoundsLocator SOUTH_WEST = new BoundsLocator(0.0, 1.0);
    public static final BoundsLocator WEST = new BoundsLocator(0.0, 0.5);
    protected final double relativeX;
    protected final double relativeY;

    public BoundsLocator() {
        this(0.0, 0.0);
    }

    public BoundsLocator(double relativeX, double relativeY) {
        this.relativeX = relativeX;
        this.relativeY = relativeY;
    }

    public BoundsLocator(Bounds bounds, Point2D p) {
        this(bounds, p.getX(), p.getY());
    }

    public BoundsLocator(Bounds bounds, double x, double y) {
        this(MathUtil.clamp((double)((x - bounds.getMinX()) / bounds.getWidth()), (double)0.0, (double)1.0), MathUtil.clamp((double)((y - bounds.getMinY()) / bounds.getHeight()), (double)0.0, (double)1.0));
    }

    public double getRelativeX() {
        return this.relativeX;
    }

    public double getRelativeY() {
        return this.relativeY;
    }

    @Override
    public Point2D locate(Figure owner) {
        Bounds bounds = owner.getLayoutBounds();
        Point2D location = new Point2D(bounds.getMinX() + bounds.getWidth() * this.relativeX, bounds.getMinY() + bounds.getHeight() * this.relativeY);
        return location;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundsLocator other = (BoundsLocator)obj;
        if (this.relativeX != other.relativeX) {
            return false;
        }
        return this.relativeY == other.relativeY;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(Double.doubleToLongBits(this.relativeX) ^ Double.doubleToLongBits(this.relativeX) >>> 32);
        hash = 71 * hash + (int)(Double.doubleToLongBits(this.relativeY) ^ Double.doubleToLongBits(this.relativeY) >>> 32);
        return hash;
    }
}

