/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import org.jhotdraw8.draw.model.DirtyBits;

public class DirtyMask {
    private final int bitmask;
    public static final DirtyMask EMPTY = new DirtyMask(0);
    public static final DirtyMask ALL = new DirtyMask(-1);

    private DirtyMask(int bitmask) {
        this.bitmask = bitmask;
    }

    public static DirtyMask of(DirtyBits ... bits) {
        int mask = 0;
        for (DirtyBits bit : bits) {
            mask |= bit.getMask();
        }
        return new DirtyMask(mask);
    }

    final int getMask() {
        return this.bitmask;
    }

    public boolean containsOneOf(DirtyBits ... bits) {
        for (DirtyBits bit : bits) {
            if ((this.bitmask & bit.getMask()) != bit.getMask()) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(DirtyBits ... bits) {
        return this.intersects(DirtyMask.of(bits));
    }

    public boolean intersects(DirtyMask that) {
        return (this.bitmask & that.bitmask) != 0;
    }

    public boolean isEmpty() {
        return this.bitmask == 0;
    }

    public DirtyMask add(DirtyMask that) {
        return new DirtyMask(this.bitmask | that.bitmask);
    }

    public DirtyMask add(DirtyBits bits) {
        return new DirtyMask(this.bitmask | bits.getMask());
    }

    public String toString() {
        return "DirtyMask{bitmask=" + Integer.toBinaryString(this.bitmask) + "}";
    }
}

