/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.model;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.fxbase.event.SimpleWeakListener;
import org.jhotdraw8.fxcollection.mapped.MappedObservableList;

public class DrawingModelFigureChildrenObservableList
extends TransformationList<Figure, Figure> {
    private final DrawingModel model;
    private final Figure parent;
    private final Listener<DrawingModelEvent> drawingModelEventListener;

    public DrawingModelFigureChildrenObservableList(DrawingModel model, Figure parent) {
        super(parent.getChildren());
        this.model = model;
        this.parent = parent;
        this.drawingModelEventListener = event -> {
            Figure node = event.getNode();
            if (node != null && node.getParent() == parent) {
                final int index = node.getParent().getChildren().indexOf((Object)node);
                this.fireChange((ListChangeListener.Change)new ListChangeListener.Change<Figure>(this, (ObservableList)this){
                    private boolean invalid;
                    {
                        super(arg0);
                        this.invalid = true;
                    }

                    public boolean next() {
                        if (this.invalid) {
                            this.invalid = false;
                            return true;
                        }
                        return false;
                    }

                    public void reset() {
                        this.invalid = true;
                    }

                    public int getFrom() {
                        return index;
                    }

                    public int getTo() {
                        return index + 1;
                    }

                    public boolean wasUpdated() {
                        return !this.invalid;
                    }

                    public List<Figure> getRemoved() {
                        return Collections.emptyList();
                    }

                    protected int[] getPermutation() {
                        return new int[0];
                    }
                });
            }
        };
        model.addDrawingModelListener((Listener<DrawingModelEvent>)new SimpleWeakListener(this.drawingModelEventListener, model::removeDrawingModelListener));
    }

    protected void sourceChanged(ListChangeListener.Change<? extends Figure> c) {
        this.fireChange((ListChangeListener.Change)new MappedObservableList.ChangeProxy((ObservableList)this, c, Function.identity()));
    }

    public int getSourceIndex(int index) {
        return index;
    }

    public int getViewIndex(int index) {
        return index;
    }

    public Figure get(int index) {
        return (Figure)this.getSource().get(index);
    }

    public int size() {
        return this.getSource().size();
    }

    public void add(int index, Figure element) {
        this.model.insertChildAt(element, this.parent, index);
    }

    public Figure remove(int index) {
        return this.model.removeFromParent(this.parent, index);
    }

    public boolean remove(Object o) {
        if (o instanceof Figure) {
            Figure f = (Figure)o;
            if (f.getParent() != null) {
                this.model.removeFromParent(f);
            }
            return f.getParent() == null;
        }
        return false;
    }

    public Figure set(int index, Figure e) {
        Figure oldChild = this.remove(index);
        this.add(index, e);
        return oldChild;
    }
}

