/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.popup.AbstractPicker;

public class BooleanPicker
extends AbstractPicker<Boolean> {
    private ContextMenu contextMenu;
    private MenuItem noneItem;
    private final boolean nullable;

    public BooleanPicker(boolean nullable) {
        this.nullable = nullable;
    }

    private void init(BiConsumer<Boolean, Boolean> callback) {
        Resources labels = DrawLabels.getResources();
        this.contextMenu = new ContextMenu();
        MenuItem unsetItem = new MenuItem();
        this.noneItem = new MenuItem();
        MenuItem trueItem = new MenuItem();
        MenuItem falseItem = new MenuItem();
        unsetItem.setOnAction(e -> callback.accept(false, null));
        this.noneItem.setOnAction(e -> callback.accept(true, null));
        trueItem.setOnAction(e -> callback.accept(true, true));
        falseItem.setOnAction(e -> callback.accept(true, false));
        labels.configureMenuItem(unsetItem, "value.unset");
        labels.configureMenuItem(this.noneItem, "value.none");
        labels.configureMenuItem(trueItem, "value.true");
        labels.configureMenuItem(falseItem, "value.false");
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{trueItem, falseItem, new SeparatorMenuItem(), unsetItem, this.noneItem});
    }

    private void update(BiConsumer<Boolean, Boolean> callback) {
        this.init(callback);
        this.noneItem.setVisible(this.nullable);
    }

    @Override
    public void show(Node anchor, double screenX, double screenY, Boolean initialValue, BiConsumer<Boolean, Boolean> callback) {
        this.update(callback);
        this.contextMenu.show(anchor, screenX, screenY);
    }
}

