/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.io.IOException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.jhotdraw8.application.ApplicationLabels;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.draw.popup.CssColorChooserController;
import org.jspecify.annotations.Nullable;

public class CssColorDialog {
    private final ObjectProperty<CssColor> currentColor = new SimpleObjectProperty((Object)NamedCssColor.WHITE);
    private final ObjectProperty<CssColor> customColor = new SimpleObjectProperty((Object)NamedCssColor.TRANSPARENT);
    final @Nullable ButtonType chooseButtonType;
    final @Nullable ButtonType cancelButtonType;
    private CssColorChooserController controller;
    private Dialog<ButtonType> dialog;
    private Runnable onSave;
    private Runnable onUse;
    private Runnable onCancel;

    public CssColorDialog(Window owner) {
        Resources labels = ApplicationLabels.getGuiResources();
        this.dialog = new Dialog();
        DialogPane dialogPane = this.dialog.getDialogPane();
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(this.getClass().getResource("CssColorChooser.fxml"));
            loader.setResources(labels.asResourceBundle());
            loader.load();
            Parent root = (Parent)loader.getRoot();
            dialogPane.setContent((Node)root);
            this.controller = (CssColorChooserController)loader.getController();
            this.currentColor.bindBidirectional(this.controller.colorProperty());
        }
        catch (IOException ex) {
            dialogPane.setContent((Node)new Label(ex.getMessage()));
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + ex.getMessage(), ex);
        }
        this.dialog.setResizable(false);
        this.dialog.initModality(Modality.APPLICATION_MODAL);
        this.dialog.initStyle(StageStyle.UTILITY);
        this.dialog.setResizable(false);
        this.chooseButtonType = new ButtonType(labels.getTextProperty("FontChooser.choose"), ButtonBar.ButtonData.OK_DONE);
        this.cancelButtonType = new ButtonType(labels.getTextProperty("FontChooser.cancel"), ButtonBar.ButtonData.CANCEL_CLOSE);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{this.chooseButtonType, this.cancelButtonType});
    }

    public @Nullable ObjectProperty<CssColor> currentColorProperty() {
        return this.currentColor;
    }

    public @Nullable ObjectProperty<CssColor> customColorProperty() {
        return this.customColor;
    }

    public CssColor getCurrentColor() {
        return (CssColor)this.currentColor.get();
    }

    public void setCurrentColor(CssColor currentColor) {
        this.currentColor.set((Object)currentColor);
    }

    public CssColor getCustomColor() {
        return (CssColor)this.customColor.get();
    }

    public void setCustomColor(CssColor customColor) {
        this.customColor.set((Object)customColor);
    }

    public Runnable getOnCancel() {
        return this.onCancel;
    }

    public void setOnCancel(Runnable onCancel) {
        this.onCancel = onCancel;
    }

    public Runnable getOnSave() {
        return this.onSave;
    }

    public void setOnSave(Runnable onSave) {
        this.onSave = onSave;
    }

    public Runnable getOnUse() {
        return this.onUse;
    }

    public void setOnUse(Runnable onUse) {
        this.onUse = onUse;
    }

    public void show() {
        Runnable onSave;
        Optional value = this.dialog.showAndWait();
        if (value.orElse(null) == this.chooseButtonType && (onSave = this.getOnSave()) != null) {
            onSave.run();
        }
    }
}

