/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.util.function.BiConsumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.paint.Color;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.draw.DrawLabels;
import org.jhotdraw8.draw.css.value.CssColor;
import org.jhotdraw8.draw.css.value.NamedCssColor;
import org.jhotdraw8.fxbase.binding.CustomBinding;
import org.jspecify.annotations.Nullable;

public class CssColorPopup {
    private final ContextMenu contextMenu;
    private final MenuItem noneItem;
    private final ColorPicker colorPicker;
    private BiConsumer<Boolean, CssColor> callback;
    private final ObjectProperty<CssColor> currentColor = new SimpleObjectProperty((Object)NamedCssColor.WHITE);

    public CssColorPopup() {
        Resources labels = DrawLabels.getResources();
        this.contextMenu = new ContextMenu();
        this.colorPicker = new ColorPicker();
        MenuItem colorPickerItem = new MenuItem(null, (Node)this.colorPicker);
        this.contextMenu.getItems().add((Object)colorPickerItem);
        this.colorPicker.setOnAction(event -> this.callback.accept(true, CssColor.ofColor((Color)this.colorPicker.getValue())));
        MenuItem unsetItem = new MenuItem();
        unsetItem.setOnAction(e -> this.callback.accept(false, null));
        this.noneItem = new MenuItem();
        this.noneItem.setOnAction(e -> this.callback.accept(true, null));
        labels.configureMenuItem(unsetItem, "value.unset");
        labels.configureMenuItem(this.noneItem, "value.none");
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), unsetItem, this.noneItem});
        CustomBinding.bindBidirectionalAndConvert((WritableValue)this.colorPicker.valueProperty(), this.currentColor, CssColor::ofColor, CssColor::toColor);
    }

    public BiConsumer<Boolean, CssColor> getCallback() {
        return this.callback;
    }

    public void setCallback(BiConsumer<Boolean, CssColor> callback) {
        this.callback = callback;
    }

    public CssColor getCurrentColor() {
        return (CssColor)this.currentColor.get();
    }

    public @Nullable ObjectProperty<CssColor> currentColorProperty() {
        return this.currentColor;
    }

    public void setCurrentColor(CssColor currentColor) {
        this.currentColor.set((Object)currentColor);
    }

    public void show(Node anchor, double screenX, double screenY) {
        this.contextMenu.show(anchor, screenX, screenY);
    }
}

