/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.popup;

import java.util.Optional;
import java.util.function.BiConsumer;
import javafx.scene.Node;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.css.value.CssFont;
import org.jhotdraw8.draw.popup.AbstractPicker;
import org.jhotdraw8.fxcontrols.fontchooser.FontDialog;
import org.jhotdraw8.fxcontrols.fontchooser.FontFamilySize;
import org.jspecify.annotations.Nullable;

public class CssFontPicker
extends AbstractPicker<CssFont> {
    private FontDialog dialog;

    private void update(Node anchor) {
        if (this.dialog == null) {
            this.dialog = new FontDialog();
        }
    }

    @Override
    public void show(Node anchor, double screenX, double screenY, @Nullable CssFont initialValue, BiConsumer<Boolean, CssFont> callback) {
        CssFont initial = initialValue == null ? new CssFont("Arial", FontWeight.NORMAL, FontPosture.REGULAR, CssSize.of((double)13.0)) : initialValue;
        this.update(anchor);
        Optional s = this.dialog.showAndWait(new FontFamilySize(initial.getFamily(), initial.getSize().getConvertedValue()));
        s.ifPresent(v -> callback.accept(true, new CssFont(v.family(), initial.getWeight(), initial.getPosture(), CssSize.of((double)v.size()))));
    }
}

