/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.render;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedSet;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.css.value.DefaultUnitConverter;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.figure.Drawing;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.SimpleDrawingModel;
import org.jhotdraw8.draw.render.NodeFinder;
import org.jhotdraw8.draw.render.RenderContext;
import org.jhotdraw8.draw.render.SimpleRenderContext;
import org.jhotdraw8.draw.render.WritableRenderContext;
import org.jhotdraw8.fxbase.beans.AbstractPropertyBean;
import org.jhotdraw8.fxbase.beans.NonNullObjectProperty;
import org.jhotdraw8.fxbase.tree.TreeModelEvent;
import org.jhotdraw8.geom.FXTransforms;
import org.jspecify.annotations.Nullable;

public class InteractiveDrawingRenderer
extends AbstractPropertyBean {
    public static final String RENDER_CONTEXT_PROPERTY = "renderContext";
    public static final String MODEL_PROPERTY = "model";
    public static final String DRAWING_VIEW_PROPERTY = "drawingView";
    private final NonNullObjectProperty<WritableRenderContext> renderContext = new NonNullObjectProperty((Object)this, "renderContext", (Object)new SimpleRenderContext());
    private final NonNullObjectProperty<DrawingModel> model = new NonNullObjectProperty((Object)this, "model", (Object)new SimpleDrawingModel());
    private final Group drawingPane = new Group(){

        protected void layoutChildren() {
            InteractiveDrawingRenderer.this.paint();
        }
    };
    private final ObjectProperty<Bounds> clipBounds = new SimpleObjectProperty((Object)this, "clipBounds", (Object)new BoundingBox(0.0, 0.0, 800.0, 600.0));
    private final SequencedSet<Figure> dirtyFigureNodes = new LinkedHashSet<Figure>();
    private final DoubleProperty zoomFactor = new SimpleDoubleProperty((Object)this, "zoomFactor", 1.0);
    private final IntegerProperty updateLimit = new SimpleIntegerProperty((Object)this, "updateLimit", 10000);
    private final Map<Figure, Node> figureToNodeMap = new IdentityHashMap<Figure, Node>();
    private final Map<Node, Figure> nodeToFigureMap = new IdentityHashMap<Node, Figure>();
    private final ObjectProperty<DrawingView> drawingView = new SimpleObjectProperty((Object)this, "drawingView");
    private final ObjectProperty<DrawingEditor> editor = new SimpleObjectProperty((Object)this, "editor", null);
    private final Listener<TreeModelEvent<Figure>> treeModelListener = this::onTreeModelEvent;
    private final NodeFinder nodeFinder = new NodeFinder();
    private @Nullable Boolean canSortByViewOrder = null;
    private @Nullable Method getViewOrder = null;

    public InteractiveDrawingRenderer() {
        this.drawingPane.setManaged(true);
        this.model.addListener(this::onDrawingModelChanged);
        this.clipBounds.addListener(this::onClipBoundsChanged);
    }

    public ObjectProperty<Bounds> clipBoundsProperty() {
        return this.clipBounds;
    }

    public ObjectProperty<DrawingView> drawingViewProperty() {
        return this.drawingView;
    }

    public ObjectProperty<DrawingEditor> editorProperty() {
        return this.editor;
    }

    public DrawingView getDrawingView() {
        return (DrawingView)this.drawingView.get();
    }

    public void setDrawingView(DrawingView drawingView) {
        this.drawingView.set((Object)drawingView);
    }

    public @Nullable Node findFigureNode(Figure figure, double vx, double vy) {
        Node n = this.figureToNodeMap.get(figure);
        if (n == null) {
            return null;
        }
        Transform viewToNode = null;
        for (Node p = n; p != null; p = p.getParent()) {
            try {
                viewToNode = FXTransforms.concat((Transform[])new Transform[]{viewToNode, p.getLocalToParentTransform().createInverse()});
            }
            catch (NonInvertibleTransformException e) {
                return null;
            }
            if (p == this.drawingPane) break;
        }
        Point2D pl = FXTransforms.transform(viewToNode, (double)vx, (double)vy);
        double tolerance = this.getEditor().getTolerance();
        double radius = FXTransforms.deltaTransform(viewToNode, (double)tolerance, (double)0.0).magnitude();
        return this.nodeFinder.findNodeRecursive(n, pl.getX(), pl.getY(), radius);
    }

    public List<Map.Entry<Figure, Double>> findFigures(double vx, double vy, boolean decompose, Predicate<Figure> predicate) {
        Transform vt = this.getDrawingView().getViewToWorld();
        Point2D pp = vt.transform(vx, vy);
        ArrayList<Map.Entry<Figure, Double>> list = new ArrayList<Map.Entry<Figure, Double>>();
        double tolerance = this.getEditor().getTolerance();
        Parent parent = (Parent)this.figureToNodeMap.get(this.getDrawing());
        for (Node child : this.frontToBack(parent)) {
            this.findFiguresRecursive(child, child.parentToLocal(pp), list, decompose, predicate, FXTransforms.inverseDeltaTransform((Transform)child.getLocalToParentTransform(), (double)tolerance, (double)0.0).magnitude());
        }
        return list;
    }

    private Node[] frontToBack(@Nullable Parent parent) {
        if (parent == null) {
            return new Node[0];
        }
        ObservableList children = parent.getChildrenUnmodifiable();
        Node[] array = new Node[children.size()];
        for (int i = 0; i < array.length; ++i) {
            array[array.length - i - 1] = (Node)children.get(i);
        }
        if (array.length > 1) {
            this.sortByViewOrder(array);
        }
        return array;
    }

    private void sortByViewOrder(Node[] array) {
        if (this.canSortByViewOrder == null) {
            try {
                this.getViewOrder = Node.class.getMethod("getViewOrder", new Class[0]);
                this.canSortByViewOrder = true;
            }
            catch (Throwable e) {
                this.canSortByViewOrder = false;
            }
        }
        if (this.getViewOrder != null) {
            Arrays.sort(array, Comparator.comparingDouble(n -> {
                try {
                    return (Double)this.getViewOrder.invoke(n, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return 0.0;
                }
            }));
        }
    }

    public List<Map.Entry<Figure, Double>> findFiguresInside(double vx, double vy, double vwidth, double vheight, boolean decompose, Predicate<Figure> predicate) {
        Transform vt = this.getDrawingView().getViewToWorld();
        Point2D pxy = vt.transform(vx, vy);
        Point2D pwh = vt.deltaTransform(vwidth, vheight);
        BoundingBox r = new BoundingBox(pxy.getX(), pxy.getY(), pwh.getX(), pwh.getY());
        ArrayList<Map.Entry<Figure, Double>> list = new ArrayList<Map.Entry<Figure, Double>>();
        Parent parent = (Parent)this.figureToNodeMap.get(this.getDrawing());
        for (Node child : this.frontToBack(parent)) {
            this.findFiguresInsideRecursive(child, child.parentToLocal((Bounds)r), list, decompose, predicate);
        }
        return list;
    }

    private boolean findFiguresInsideRecursive(Node node, Bounds pp, List<Map.Entry<Figure, Double>> found, boolean decompose, Predicate<Figure> predicate) {
        boolean isWanted;
        if (!node.isVisible()) {
            return false;
        }
        boolean isIntersecting = pp.intersects(node.getBoundsInLocal());
        if (!isIntersecting) {
            return false;
        }
        boolean isInside = pp.contains(node.getBoundsInLocal());
        Figure figure = this.nodeToFigureMap.get(node);
        boolean bl = isWanted = figure != null && predicate.test(figure);
        if (isInside && figure != null && !decompose && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, 0.0));
            return true;
        }
        boolean foundAChildFigure = false;
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : this.frontToBack(parent)) {
                foundAChildFigure |= this.findFiguresInsideRecursive(child, child.parentToLocal(pp), found, decompose, predicate);
            }
        }
        if (isInside && !foundAChildFigure && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, 0.0));
        }
        return true;
    }

    public List<Map.Entry<Figure, Double>> findFiguresIntersecting(double vx, double vy, double vwidth, double vheight, boolean decompose, Predicate<Figure> predicate) {
        Transform vt = this.getDrawingView().getViewToWorld();
        Point2D pxy = vt.transform(vx, vy);
        Point2D pwh = vt.deltaTransform(vwidth, vheight);
        BoundingBox r = new BoundingBox(pxy.getX(), pxy.getY(), pwh.getX(), pwh.getY());
        ArrayList<Map.Entry<Figure, Double>> list = new ArrayList<Map.Entry<Figure, Double>>();
        Parent parent = (Parent)this.figureToNodeMap.get(this.getDrawing());
        for (Node child : this.frontToBack(parent)) {
            this.findFiguresIntersectingRecursive(child, child.parentToLocal((Bounds)r), list, decompose, predicate);
        }
        return list;
    }

    private boolean findFiguresIntersectingRecursive(Node node, Bounds pp, List<Map.Entry<Figure, Double>> found, boolean decompose, Predicate<Figure> predicate) {
        boolean isWanted;
        if (!node.isVisible()) {
            return false;
        }
        boolean intersects = pp.intersects(node.getBoundsInLocal());
        if (!intersects) {
            return false;
        }
        Figure figure = this.nodeToFigureMap.get(node);
        boolean bl = isWanted = figure != null && predicate.test(figure);
        if (figure != null && !decompose && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, 0.0));
            return true;
        }
        boolean foundAChildFigure = false;
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : this.frontToBack(parent)) {
                foundAChildFigure |= this.findFiguresIntersectingRecursive(child, child.parentToLocal(pp), found, decompose, predicate);
            }
        }
        if (!foundAChildFigure && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, 0.0));
        }
        return true;
    }

    private boolean findFiguresRecursive(Node node, Point2D center, List<Map.Entry<Figure, Double>> found, boolean decompose, Predicate<Figure> figurePredicate, double radius) {
        boolean isWanted;
        if (!node.isVisible()) {
            return false;
        }
        Double distance = this.nodeFinder.contains(node, center, radius);
        if (distance == null) {
            return false;
        }
        Figure figure = this.nodeToFigureMap.get(node);
        boolean bl = isWanted = figure != null && figurePredicate.test(figure);
        if (figure != null && !decompose && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, distance));
            return true;
        }
        boolean foundAChildFigure = false;
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : this.frontToBack(parent)) {
                foundAChildFigure |= this.findFiguresRecursive(child, child.parentToLocal(center), found, decompose, figurePredicate, Math.abs(FXTransforms.inverseDeltaTransform((Transform)child.getLocalToParentTransform(), (double)radius, (double)radius).getX()));
            }
        }
        if (!foundAChildFigure && isWanted) {
            found.add(new AbstractMap.SimpleImmutableEntry<Figure, Double>(figure, distance));
            return true;
        }
        return false;
    }

    public Bounds getClipBounds() {
        return (Bounds)this.clipBounds.get();
    }

    public void setClipBounds(Bounds clipBounds) {
        this.clipBounds.set((Object)clipBounds);
    }

    public @Nullable Drawing getDrawing() {
        return this.getModel() == null ? null : this.getModel().getDrawing();
    }

    DrawingEditor getEditor() {
        return (DrawingEditor)this.editorProperty().get();
    }

    public DrawingModel getModel() {
        return (DrawingModel)this.model.get();
    }

    public void setModel(DrawingModel model) {
        this.model.set((Object)model);
    }

    public Node getNode() {
        return this.drawingPane;
    }

    public @Nullable Node getNode(@Nullable Figure f) {
        if (f == null) {
            return null;
        }
        Node n = this.figureToNodeMap.get(f);
        if (n == null) {
            n = f.createNode(this.getRenderContext());
            this.figureToNodeMap.put(f, n);
            this.nodeToFigureMap.put(n, f);
            this.dirtyFigureNodes.add(f);
            this.repaint();
        }
        return n;
    }

    public NonNullObjectProperty<WritableRenderContext> renderContextProperty() {
        return this.renderContext;
    }

    public WritableRenderContext getRenderContext() {
        return (WritableRenderContext)this.renderContext.get();
    }

    public void setRenderContext(WritableRenderContext newValue) {
        this.renderContext.set((Object)newValue);
    }

    public double getZoomFactor() {
        return this.zoomFactorProperty().get();
    }

    public void setZoomFactor(double newValue) {
        this.zoomFactorProperty().set(newValue);
    }

    private boolean hasNode(Figure f) {
        return this.figureToNodeMap.containsKey(f);
    }

    private void invalidateFigureNode(Figure f) {
        if (this.hasNode(f)) {
            this.dirtyFigureNodes.add(f);
        }
    }

    private void invalidateLayerNodes() {
        Drawing drawing = this.getDrawing();
        if (drawing != null) {
            this.dirtyFigureNodes.addAll((Collection<Figure>)drawing.getChildren());
        }
    }

    public NonNullObjectProperty<DrawingModel> modelProperty() {
        return this.model;
    }

    private void onClipBoundsChanged(Observable observable) {
        this.invalidateLayerNodes();
        this.repaint();
    }

    private void onDrawingModelChanged(Observable o, @Nullable DrawingModel oldValue, @Nullable DrawingModel newValue) {
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.treeModelListener);
            this.dirtyFigureNodes.clear();
            this.figureToNodeMap.clear();
            this.nodeToFigureMap.clear();
        }
        if (newValue != null) {
            newValue.addTreeModelListener(this.treeModelListener);
            this.onRootChanged(newValue.getDrawing());
        }
    }

    private void onFigureAddedToParent(Figure figure) {
        for (Figure f : figure.preorderIterable()) {
            this.invalidateFigureNode(f);
        }
        this.repaint();
    }

    private void onFigureRemovedFromParent(Figure figure) {
        for (Figure f : figure.preorderIterable()) {
            this.removeNode(f);
        }
    }

    private void onNodeChanged(Figure figure) {
        this.invalidateFigureNode(figure);
        this.repaint();
    }

    private void onNodeAddedToTree(Figure f) {
    }

    private void onNodeRemovedFromTree(Figure f) {
    }

    private void onRootChanged(@Nullable Figure f) {
        ObservableList children = this.drawingPane.getChildren();
        this.nodeToFigureMap.clear();
        this.figureToNodeMap.clear();
        Node node = this.getNode(f);
        if (node == null) {
            children.clear();
        } else {
            children.setAll((Object[])new Node[]{node});
        }
        this.dirtyFigureNodes.clear();
        if (f != null) {
            this.dirtyFigureNodes.add(f);
            this.repaint();
        }
    }

    private void onSubtreeNodesChanged(Figure figure) {
        for (Figure f : figure.preorderIterable()) {
            this.dirtyFigureNodes.add(f);
        }
        this.repaint();
    }

    private void onTreeModelEvent(TreeModelEvent<Figure> event) {
        Figure f = (Figure)event.getNode();
        switch (event.getEventType()) {
            case NODE_ADDED_TO_PARENT: {
                this.onFigureAddedToParent(f);
                break;
            }
            case NODE_REMOVED_FROM_PARENT: {
                this.onFigureRemovedFromParent(f);
                break;
            }
            case NODE_ADDED_TO_TREE: {
                this.onNodeAddedToTree(f);
                break;
            }
            case NODE_REMOVED_FROM_TREE: {
                this.onNodeRemovedFromTree(f);
                break;
            }
            case NODE_CHANGED: {
                this.onNodeChanged(f);
                break;
            }
            case ROOT_CHANGED: {
                this.onRootChanged(f);
                break;
            }
            case SUBTREE_NODES_CHANGED: {
                this.onSubtreeNodesChanged(f);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(event.getEventType()) + " not supported");
            }
        }
    }

    private void paint() {
        this.updateRenderContext();
        for (int remainingLimit = Math.max(1, this.getUpdateLimit()); !this.dirtyFigureNodes.isEmpty() && remainingLimit > 0; remainingLimit -= this.updateNodes(remainingLimit)) {
            this.getModel().validate(this.getRenderContext());
        }
        if (!this.dirtyFigureNodes.isEmpty()) {
            this.repaint();
        }
    }

    public void paintImmediately() {
        this.paint();
    }

    private void updateRenderContext() {
        this.getRenderContext().set(RenderContext.CLIP_BOUNDS, this.getClipBounds());
        DefaultUnitConverter units = new DefaultUnitConverter(96.0, 1.0, 1024.0 / this.getZoomFactor(), 768.0 / this.getZoomFactor());
        this.getRenderContext().set(RenderContext.UNIT_CONVERTER_KEY, units);
    }

    private void removeNode(Figure f) {
        Node oldNode = this.figureToNodeMap.remove(f);
        if (oldNode != null) {
            Figure removedFigure = this.nodeToFigureMap.remove(oldNode);
            this.figureToNodeMap.remove(removedFigure);
        }
        this.dirtyFigureNodes.remove(f);
    }

    public void repaint() {
        this.drawingPane.requestLayout();
    }

    private int updateNodes(int limit) {
        Node node;
        Figure f;
        int i;
        int n;
        Bounds visibleRectInWorld = this.getClipBounds();
        Figure[] copyOfDirtyFigureNodes = this.dirtyFigureNodes.toArray(new Figure[0]);
        int count = 0;
        if (copyOfDirtyFigureNodes.length > limit) {
            n = copyOfDirtyFigureNodes.length;
            for (i = 0; i < n && count < limit; ++i) {
                f = copyOfDirtyFigureNodes[i];
                if (!f.getVisualBoundsInWorld().intersects(visibleRectInWorld)) continue;
                copyOfDirtyFigureNodes[i] = null;
                ++count;
                node = this.getNode(f);
                if (node == null) continue;
                f.updateNode(this.getRenderContext(), node);
                this.dirtyFigureNodes.remove(f);
            }
            if (count == limit) {
                return count;
            }
        }
        n = copyOfDirtyFigureNodes.length;
        for (i = 0; i < n && count < limit; ++i) {
            f = copyOfDirtyFigureNodes[i];
            ++count;
            node = this.getNode(f);
            if (node == null) continue;
            f.updateNode(this.getRenderContext(), node);
            this.dirtyFigureNodes.remove(f);
        }
        return count;
    }

    public DoubleProperty zoomFactorProperty() {
        return this.zoomFactor;
    }

    public int getUpdateLimit() {
        return this.updateLimit.get();
    }

    public IntegerProperty updateLimitProperty() {
        return this.updateLimit;
    }

    public void setUpdateLimit(int updateLimit) {
        this.updateLimit.set(updateLimit);
    }
}

