/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ZoomEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javax.swing.event.UndoableEditEvent;
import org.jhotdraw8.application.AbstractDisableable;
import org.jhotdraw8.application.EditableComponent;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.tool.Tool;
import org.jhotdraw8.draw.tool.ToolEvent;
import org.jhotdraw8.fxbase.undo.UndoableEditHelper;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jspecify.annotations.Nullable;

public abstract class AbstractTool
extends AbstractDisableable
implements Tool {
    private ObservableMap<Key<?>, Object> properties;
    private final ObjectProperty<DrawingView> drawingView = new SimpleObjectProperty((Object)this, "drawingView");
    private final ObjectProperty<DrawingEditor> drawingEditor = new SimpleObjectProperty((Object)this, "drawingEditor");
    protected final BorderPane eventPane;
    protected final BorderPane drawPane;
    protected final StackPane node;
    private final LinkedList<Listener<ToolEvent>> toolListeners;
    protected final UndoableEditHelper undoHelper;

    public AbstractTool(String name, @Nullable Resources rsrc) {
        this.drawingView.addListener((observable, oldValue, newValue) -> this.stopEditing());
        this.eventPane = new EventPane();
        this.drawPane = new BorderPane();
        this.node = new StackPane();
        this.eventPane.addEventHandler(MouseEvent.ANY, event -> {
            try {
                DrawingView dv = (DrawingView)this.drawingView.get();
                if (dv != null) {
                    EventType type = event.getEventType();
                    if (type == MouseEvent.MOUSE_MOVED) {
                        this.onMouseMoved((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_DRAGGED) {
                        this.onMouseDragged((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_EXITED) {
                        this.onMouseExited((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_ENTERED) {
                        this.onMouseEntered((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_RELEASED) {
                        this.onMouseReleased((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_PRESSED) {
                        this.onMousePressed((MouseEvent)event, dv);
                    } else if (type == MouseEvent.MOUSE_CLICKED) {
                        this.onMouseClicked((MouseEvent)event, dv);
                    }
                    event.consume();
                }
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unexpected Exception " + t.getMessage(), t);
            }
        });
        this.eventPane.addEventHandler(KeyEvent.ANY, event -> {
            DrawingView dv = (DrawingView)this.drawingView.get();
            if (dv != null) {
                EventType type = event.getEventType();
                if (type == KeyEvent.KEY_PRESSED) {
                    this.onKeyPressed((KeyEvent)event, dv);
                } else if (type == KeyEvent.KEY_RELEASED) {
                    this.onKeyReleased((KeyEvent)event, dv);
                } else if (type == KeyEvent.KEY_TYPED) {
                    this.onKeyTyped((KeyEvent)event, dv);
                }
                event.consume();
            }
        });
        this.eventPane.addEventHandler(ZoomEvent.ANY, event -> {
            DrawingView dv = (DrawingView)this.drawingView.get();
            if (dv != null) {
                EventType type = event.getEventType();
                if (type == ZoomEvent.ZOOM) {
                    this.onZoom((ZoomEvent)event, dv);
                } else if (type == ZoomEvent.ZOOM_STARTED) {
                    this.onZoomStarted((ZoomEvent)event, dv);
                } else if (type == ZoomEvent.ZOOM_FINISHED) {
                    this.onZoomFinished((ZoomEvent)event, dv);
                }
                event.consume();
            }
        });
        this.toolListeners = new LinkedList();
        this.undoHelper = new UndoableEditHelper((Object)this, this::forwardUndoableEdit);
        this.set((MapAccessor)NAME, name);
        if (rsrc != null) {
            this.applyResources(rsrc);
        }
        this.node.getChildren().addAll((Object[])new Node[]{this.drawPane, this.eventPane});
    }

    public final ObservableMap<Key<?>, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableHashMap();
        }
        return this.properties;
    }

    @Override
    public ObjectProperty<DrawingView> drawingViewProperty() {
        return this.drawingView;
    }

    @Override
    public ObjectProperty<DrawingEditor> drawingEditorProperty() {
        return this.drawingEditor;
    }

    protected void applyResources(Resources rsrc) {
        String name = (String)this.get((MapAccessor)NAME);
        this.set((MapAccessor)LABEL, rsrc.getTextProperty(name));
        this.set((MapAccessor)LARGE_ICON_KEY, rsrc.getLargeIconProperty(name, this.getClass()));
        this.set((MapAccessor)SHORT_DESCRIPTION, rsrc.getToolTipTextProperty(name));
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    protected void stopEditing() {
    }

    @Override
    public void editDelete() {
        if (this.getDrawingView() != null) {
            DrawingView v = this.getDrawingView();
            v.getDrawing().getChildren().removeAll(v.getSelectedFigures());
        }
    }

    @Override
    public void editCut() {
    }

    @Override
    public void editCopy() {
    }

    @Override
    public void editDuplicate() {
    }

    @Override
    public void editPaste() {
    }

    protected void onMouseMoved(MouseEvent event, DrawingView view) {
    }

    protected void onMouseDragged(MouseEvent event, DrawingView view) {
    }

    protected void onMouseExited(MouseEvent event, DrawingView view) {
    }

    protected void onMouseEntered(MouseEvent event, DrawingView view) {
    }

    protected void onMouseReleased(MouseEvent event, DrawingView view) {
    }

    protected void onMousePressed(MouseEvent event, DrawingView view) {
    }

    protected void onMouseClicked(MouseEvent event, DrawingView view) {
    }

    protected void onKeyPressed(KeyEvent event, DrawingView view) {
        if (event.getCode() == KeyCode.ESCAPE) {
            this.fireToolDone();
        } else if (event.getCode() == KeyCode.ENTER) {
            this.stopEditing();
        }
    }

    protected void onKeyReleased(KeyEvent event, DrawingView view) {
    }

    protected void onKeyTyped(KeyEvent event, DrawingView view) {
    }

    @Override
    public void activate(DrawingEditor editor) {
        editor.setHelpText(this.getHelpText());
    }

    @Override
    public void deactivate(DrawingEditor editor) {
    }

    @Override
    public void addToolListener(Listener<ToolEvent> listener) {
        this.toolListeners.add(listener);
    }

    @Override
    public void removeToolListener(Listener<ToolEvent> listener) {
        this.toolListeners.remove(listener);
    }

    protected void fire(ToolEvent event) {
        for (Listener listener : this.toolListeners) {
            listener.handle((Object)event);
        }
    }

    protected void onZoom(ZoomEvent event, DrawingView dv) {
    }

    protected void onZoomStarted(ZoomEvent event, DrawingView dv) {
    }

    protected void onZoomFinished(ZoomEvent event, DrawingView dv) {
    }

    protected void fireToolStarted() {
        this.fire(new ToolEvent(this, ToolEvent.EventType.TOOL_STARTED));
    }

    protected void fireToolDone() {
        this.fire(new ToolEvent(this, ToolEvent.EventType.TOOL_DONE));
    }

    protected void requestFocus() {
        Platform.runLater(() -> ((BorderPane)this.eventPane).requestFocus());
    }

    @Override
    public ReadOnlyBooleanProperty focusedProperty() {
        return this.eventPane.focusedProperty();
    }

    protected void forwardUndoableEdit(UndoableEditEvent event) {
        DrawingEditor editor = this.getDrawingEditor();
        if (editor != null) {
            editor.getUndoManager().undoableEditHappened(event);
        }
    }

    private class EventPane
    extends BorderPane
    implements EditableComponent {
        public EventPane() {
            this.setId("toolEventPane");
        }

        private @Nullable EditableComponent getEditableParent() {
            DrawingView dv = AbstractTool.this.getDrawingView();
            if (dv != null && dv.getNode() instanceof EditableComponent) {
                return (EditableComponent)dv.getNode();
            }
            return null;
        }

        public void selectAll() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.selectAll();
            }
        }

        public void clearSelection() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.clearSelection();
            }
        }

        public @Nullable ReadOnlyBooleanProperty selectionEmptyProperty() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                return p.selectionEmptyProperty();
            }
            return null;
        }

        public void deleteSelection() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.deleteSelection();
            }
        }

        public void duplicateSelection() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.duplicateSelection();
            }
        }

        public void cut() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.cut();
            }
        }

        public void copy() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.copy();
            }
        }

        public void paste() {
            EditableComponent p = this.getEditableParent();
            if (p != null) {
                p.paste();
            }
        }
    }
}

