/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.function.Supplier;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AnchorableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractCreationTool;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public class CreationTool
extends AbstractCreationTool<Figure> {
    private double defaultWidth = 100.0;
    private double defaultHeight = 100.0;
    protected double x1;
    protected double y1;
    protected double x2;
    protected double y2;
    private final double minSize = 2.0;

    public CreationTool(String name, Resources rsrc, Supplier<Figure> factory) {
        this(name, rsrc, (Supplier<? extends Figure>)factory, LayerFigure::new);
    }

    public CreationTool(String name, Resources rsrc, Supplier<? extends Figure> figureFactory, Supplier<Layer> layerFactory) {
        super(name, rsrc, figureFactory, layerFactory);
        this.node.setCursor(Cursor.CROSSHAIR);
    }

    public double getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(double defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public double getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(double defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    protected void stopEditing() {
        this.createdFigure = null;
    }

    @Override
    protected void onMousePressed(MouseEvent event, DrawingView view) {
        this.undoHelper.stopCompositeEdit();
        this.createdFigure = this.createFigure();
        Figure parent = this.getOrCreateParent(view, this.createdFigure);
        if (parent == null) {
            event.consume();
            this.createdFigure = null;
            return;
        }
        this.undoHelper.startCompositeEdit(null);
        this.x1 = event.getX();
        this.y1 = event.getY();
        this.x2 = this.x1;
        this.y2 = this.y1;
        double anchorX = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_X)), (double)0.0, (double)1.0);
        double anchorY = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_Y)), (double)0.0, (double)1.0);
        CssPoint2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(parent.worldToLocal(view.viewToWorld(new Point2D(this.x1, this.y1)))));
        this.createdFigure.reshapeInLocal(anchorX == 0.0 ? c.getX() : c.getX().subtract(CssSize.of((double)1.0).multiply(anchorX)), anchorY == 0.0 ? c.getY() : c.getY().subtract(CssSize.of((double)1.0).multiply(anchorY)), CssSize.of((double)1.0), CssSize.of((double)1.0));
        DrawingModel dm = view.getModel();
        view.setActiveParent(parent);
        dm.addChildTo(this.createdFigure, parent);
        event.consume();
    }

    @Override
    protected void onMouseReleased(MouseEvent event, DrawingView dv) {
        this.undoHelper.stopCompositeEdit();
        if (this.createdFigure != null) {
            if (Math.abs(this.x2 - this.x1) < 2.0 && Math.abs(this.y2 - this.y1) < 2.0) {
                double width = this.getDefaultWidth();
                double height = this.getDefaultHeight();
                CssPoint2D c1 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1, this.y1))));
                CssPoint2D c2 = dv.getConstrainer().translatePoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1 + width, this.y1 + height))), Constrainer.DIRECTION_NEAREST);
                if (c2.equals(c1)) {
                    c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(c1.getX().getConvertedValue() + this.defaultWidth, c1.getY().getConvertedValue() + this.defaultHeight));
                }
                DrawingModel dm = dv.getModel();
                this.reshapeInLocal(this.createdFigure, c1, c2, dm);
            }
            dv.selectedFiguresProperty().clear();
            dv.selectedFiguresProperty().add((Object)this.createdFigure);
            this.createdFigure = null;
        }
        event.consume();
        this.fireToolDone();
    }

    protected void reshapeInLocal(Figure figure, CssPoint2D c1, CssPoint2D c2, DrawingModel dm) {
        dm.reshapeInLocal(figure, c1.getX(), c1.getY(), c2.getX().subtract(c1.getX()), c2.getY().subtract(c1.getY()));
    }

    @Override
    protected void onMouseDragged(MouseEvent event, DrawingView dv) {
        this.undoHelper.startCompositeEdit(null);
        if (this.createdFigure != null) {
            this.x2 = event.getX();
            this.y2 = event.getY();
            CssPoint2D c1 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1, this.y1))));
            CssPoint2D c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x2, this.y2))));
            CssSize newWidth = c2.getX().subtract(c1.getX());
            CssSize newHeight = c2.getY().subtract(c1.getY());
            boolean keepAspect = event.isShiftDown();
            if (keepAspect) {
                double preferredAspectRatio = this.createdFigure.getPreferredAspectRatio();
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > preferredAspectRatio) {
                    newHeight = CssSize.of((double)(newWidth.getConvertedValue() * preferredAspectRatio));
                } else {
                    newWidth = CssSize.of((double)(newHeight.getConvertedValue() / preferredAspectRatio));
                }
            }
            DrawingModel dm = dv.getModel();
            dm.reshapeInLocal(this.createdFigure, c1.getX(), c1.getY(), newWidth, newHeight);
        }
        event.consume();
    }

    @Override
    public void activate(DrawingEditor editor) {
        this.requestFocus();
        super.activate(editor);
    }

    @Override
    public String getHelpText() {
        return "CreationTool\n  Click on the drawing view. The tool will create a new figure with default size at the clicked location.\nOr:\n  Press and drag the mouse over the drawing view to define the diagonal of a rectangle. The tool will create a new figure that fits into the rectangle.";
    }
}

