/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.tool;

import java.util.function.Supplier;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import org.jhotdraw8.application.resources.Resources;
import org.jhotdraw8.base.util.MathUtil;
import org.jhotdraw8.css.value.CssSize;
import org.jhotdraw8.draw.DrawingEditor;
import org.jhotdraw8.draw.DrawingView;
import org.jhotdraw8.draw.constrain.Constrainer;
import org.jhotdraw8.draw.css.value.CssPoint2D;
import org.jhotdraw8.draw.figure.AnchorableFigure;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.figure.Layer;
import org.jhotdraw8.draw.figure.LayerFigure;
import org.jhotdraw8.draw.figure.TextEditableFigure;
import org.jhotdraw8.draw.handle.HandleType;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.tool.AbstractCreationTool;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;
import org.jspecify.annotations.Nullable;

public class TextCreationTool
extends AbstractCreationTool<Figure> {
    private double defaultWidth = 100.0;
    private double defaultHeight = 100.0;
    private final TextArea textArea = new TextArea();
    private @Nullable TextEditableFigure.TextEditorData editorData;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private final double minSize = 2.0;

    public TextCreationTool(String name, Resources rsrc, Supplier<TextEditableFigure> factory) {
        this(name, rsrc, factory, LayerFigure::new);
    }

    public TextCreationTool(String name, Resources rsrc, Supplier<TextEditableFigure> figureFactory, Supplier<Layer> layerFactory) {
        super(name, rsrc, figureFactory, layerFactory);
        this.node.setCursor(Cursor.CROSSHAIR);
        this.textArea.setWrapText(true);
        this.textArea.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE) {
                keyEvent.consume();
                this.stopEditing();
            }
        });
    }

    public double getDefaultHeight() {
        return this.defaultHeight;
    }

    public void setDefaultHeight(double defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    public double getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(double defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    @Override
    protected void stopEditing() {
        if (this.editorData != null) {
            this.node.getChildren().remove((Object)this.textArea);
            DrawingView drawingView = this.getDrawingView();
            if (drawingView != null) {
                DrawingModel model = drawingView.getModel();
                model.set(this.editorData.figure(), this.editorData.textKey(), this.textArea.getText());
            }
            this.editorData = null;
        }
        this.createdFigure = null;
    }

    @Override
    protected void onMousePressed(MouseEvent event, DrawingView view) {
        Figure parent;
        event.consume();
        if (this.editorData != null) {
            this.stopEditing();
            this.fireToolDone();
            return;
        }
        this.x1 = event.getX();
        this.y1 = event.getY();
        this.x2 = this.x1;
        this.y2 = this.y1;
        this.createdFigure = this.createFigure();
        Figure figure = parent = this.createdFigure == null ? null : this.getOrCreateParent(view, this.createdFigure);
        if (parent == null) {
            this.createdFigure = null;
            event.consume();
            return;
        }
        view.setActiveParent(parent);
        DrawingModel dm = view.getModel();
        dm.addChildTo(this.createdFigure, parent);
        double anchorX = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_X)), (double)0.0, (double)1.0);
        double anchorY = MathUtil.clamp((double)((Double)this.createdFigure.getNonNull((NonNullMapAccessor)AnchorableFigure.ANCHOR_Y)), (double)0.0, (double)1.0);
        CssPoint2D c = view.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(view.viewToWorld(new Point2D(this.x1, this.y1)))));
        this.createdFigure.reshapeInLocal(anchorX == 0.0 ? c.getX() : c.getX().subtract(CssSize.of((double)this.defaultWidth).multiply(anchorX)), anchorY == 0.0 ? c.getY() : c.getY().subtract(CssSize.of((double)this.defaultHeight).multiply(anchorY)), CssSize.of((double)this.defaultWidth), CssSize.of((double)this.defaultHeight));
    }

    private void startEditing(TextEditableFigure.TextEditorData data, DrawingView dv) {
        dv.getSelectedFigures().clear();
        dv.getEditor().setHandleType(HandleType.SELECT);
        dv.getSelectedFigures().add((Object)data.figure());
        this.editorData = data;
        this.textArea.setManaged(false);
        this.node.getChildren().add((Object)this.textArea);
        Bounds bounds = dv.worldToView(data.figure().localToWorld(data.boundsInLocal()));
        this.textArea.resizeRelocate(bounds.getMinX(), bounds.getMinY(), Math.max(80.0, Math.max(this.textArea.getMinWidth(), bounds.getWidth())), Math.max(40.0, Math.max(this.textArea.getMinHeight(), bounds.getHeight())));
        this.textArea.setText((String)data.figure().get(this.editorData.textKey()));
        this.textArea.requestFocus();
    }

    @Override
    protected void onMouseReleased(MouseEvent event, DrawingView dv) {
        event.consume();
        if (this.editorData != null) {
            return;
        }
        if (this.createdFigure != null) {
            event.consume();
            if (Math.abs(this.x2 - this.x1) < 2.0 && Math.abs(this.y2 - this.y1) < 2.0) {
                CssPoint2D c1 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1, this.y1))));
                CssPoint2D c2 = dv.getConstrainer().translatePoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1 + this.defaultWidth, this.y1 + this.defaultHeight))), Constrainer.DIRECTION_NEAREST);
                if (c2.equals(c1)) {
                    c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(c1.getX().getConvertedValue() + this.defaultWidth, c1.getY().getConvertedValue() + this.defaultHeight));
                }
                DrawingModel dm = dv.getModel();
                dm.reshapeInLocal(this.createdFigure, c1.getX(), c1.getY(), c2.getX().subtract(c1.getX()), c2.getY().subtract(c1.getY()));
            }
            dv.selectedFiguresProperty().clear();
            dv.selectedFiguresProperty().add((Object)this.createdFigure);
            TextEditableFigure.TextEditorData data = ((TextEditableFigure)this.createdFigure).getTextEditorDataFor(null, null);
            this.createdFigure = null;
            if (data != null) {
                this.startEditing(data, dv);
            } else {
                this.fireToolDone();
            }
        }
    }

    @Override
    protected void onMouseDragged(MouseEvent event, DrawingView dv) {
        if (this.editorData != null) {
            return;
        }
        if (this.createdFigure != null) {
            this.x2 = event.getX();
            this.y2 = event.getY();
            CssPoint2D c1 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x1, this.y1))));
            CssPoint2D c2 = dv.getConstrainer().constrainPoint(this.createdFigure, new CssPoint2D(this.createdFigure.worldToParent(dv.viewToWorld(this.x2, this.y2))));
            CssSize newWidth = c2.getX().subtract(c1.getX());
            CssSize newHeight = c2.getY().subtract(c1.getY());
            boolean keepAspect = event.isShiftDown();
            if (keepAspect) {
                double preferredAspectRatio = this.createdFigure.getPreferredAspectRatio();
                double newRatio = newHeight.getConvertedValue() / newWidth.getConvertedValue();
                if (newRatio > preferredAspectRatio) {
                    newHeight = CssSize.of((double)(newWidth.getConvertedValue() * preferredAspectRatio));
                } else {
                    newWidth = CssSize.of((double)(newHeight.getConvertedValue() / preferredAspectRatio));
                }
            }
            DrawingModel dm = dv.getModel();
            dm.reshapeInLocal(this.createdFigure, c1.getX(), c1.getY(), newWidth, newHeight);
        }
        event.consume();
    }

    @Override
    public void activate(DrawingEditor editor) {
        this.requestFocus();
        super.activate(editor);
    }

    @Override
    public String getHelpText() {
        return "CreationTool\n  Click on the drawing view. The tool will create a new figure with default size at the clicked location.\nOr:\n  Press and drag the mouse over the drawing view to define the diagonal of a rectangle. The tool will create a new figure that fits into the rectangle.";
    }
}

