/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.undo;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelEvent;

public class DrawingModelEventUndoableEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 0L;
    private final DrawingModelEvent event;

    public DrawingModelEventUndoableEdit(DrawingModelEvent event) {
        this.event = event;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.event.getEventType() == DrawingModelEvent.EventType.PROPERTY_VALUE_CHANGED) {
            ((DrawingModel)this.event.getSource()).set(this.event.getNode(), this.event.getKey(), this.event.getOldValue());
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.event.getEventType() == DrawingModelEvent.EventType.PROPERTY_VALUE_CHANGED) {
            ((DrawingModel)this.event.getSource()).set(this.event.getNode(), this.event.getKey(), this.event.getNewValue());
        }
    }

    @Override
    public boolean isSignificant() {
        return this.event.getEventType() == DrawingModelEvent.EventType.PROPERTY_VALUE_CHANGED;
    }

    @Override
    public String getPresentationName() {
        return "Property Value";
    }
}

