/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.undo;

import java.text.MessageFormat;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw8.base.event.Listener;
import org.jhotdraw8.draw.figure.Figure;
import org.jhotdraw8.draw.model.DrawingModel;
import org.jhotdraw8.draw.model.DrawingModelEvent;
import org.jhotdraw8.fxbase.tree.TreeModel;
import org.jhotdraw8.fxbase.tree.TreeModelUndoAdapter;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jspecify.annotations.Nullable;

public class DrawingModelUndoAdapter
extends TreeModelUndoAdapter<Figure> {
    private final Listener<DrawingModelEvent> drawingModelListener = event -> {
        PropertyChangedEdit edit;
        if (((DrawingModel)event.getSource()).isValidating()) {
            return;
        }
        switch (event.getEventType()) {
            default: {
                throw new MatchException(null, null);
            }
            case PROPERTY_VALUE_CHANGED: {
                PropertyChangedEdit propertyChangedEdit = new PropertyChangedEdit((DrawingModel)event.getSource(), event.getNode(), event.getKey(), event.getOldValue(), event.getNewValue(), event.wasAdded(), event.wasRemoved());
                break;
            }
            case LAYOUT_CHANGED: 
            case STYLE_CHANGED: 
            case TRANSFORM_CHANGED: {
                PropertyChangedEdit propertyChangedEdit = edit = null;
            }
        }
        if (edit != null) {
            this.fireUndoableEdit(event.getSource(), edit);
        }
    };

    public DrawingModelUndoAdapter() {
    }

    public DrawingModelUndoAdapter(DrawingModel model) {
        this.bind(model);
    }

    public void bind(DrawingModel model) {
        super.bind((TreeModel)model);
        model.addDrawingModelListener(this.drawingModelListener);
    }

    public void unbind(DrawingModel model) {
        super.unbind((TreeModel)model);
        model.removeDrawingModelListener(this.drawingModelListener);
    }

    class PropertyChangedEdit<E>
    extends AbstractUndoableEdit {
        private final DrawingModel model;
        private final Figure figure;
        private final Key<Object> key;
        private final @Nullable Object oldValue;
        private @Nullable Object newValue;
        private final boolean wasAdded;
        private final boolean wasRemoved;

        public PropertyChangedEdit(DrawingModel model, Figure figure, @Nullable Key<Object> key, @Nullable Object oldValue, Object newValue, boolean wasAdded, boolean wasRemoved) {
            this.model = model;
            this.figure = figure;
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.wasAdded = wasAdded;
            this.wasRemoved = wasRemoved;
        }

        @Override
        public String getPresentationName() {
            return MessageFormat.format(DrawingModelUndoAdapter.this.getResourceBundle().getString("edit.changePropertyValue"), this.key.getName());
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.wasRemoved && !this.wasAdded) {
                this.model.remove(this.figure, this.key);
            } else {
                this.model.set(this.figure, this.key, this.newValue);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit anEdit) {
            if (anEdit instanceof PropertyChangedEdit) {
                PropertyChangedEdit that = (PropertyChangedEdit)anEdit;
                if (this.figure.equals(that.figure) && this.key.equals(that.key) && !this.wasAdded && !this.wasRemoved && !that.wasAdded && !that.wasRemoved) {
                    this.newValue = that.newValue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.wasAdded && !this.wasRemoved) {
                this.model.remove(this.figure, this.key);
            } else {
                this.model.set(this.figure, this.key, this.oldValue);
            }
        }

        @Override
        public String toString() {
            return "PropertyChangedEdit{figure=" + this.figure.getId() + ", " + this.key.getName() + "=" + String.valueOf(this.newValue) + "}";
        }
    }
}

