/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.xml.converter;

import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.io.CharBufferReader;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.geom.PathBuilder;
import org.jhotdraw8.geom.SvgPaths;
import org.jhotdraw8.geom.shape.BezierPath;
import org.jhotdraw8.geom.shape.BezierPathBuilder;
import org.jspecify.annotations.Nullable;

public class BezierPathXmlConverter
implements Converter<BezierPath> {
    private final boolean nullable;

    public BezierPathXmlConverter(boolean nullable) {
        this.nullable = nullable;
    }

    public @Nullable BezierPath fromString(CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        String input = buf.toString();
        buf.position(buf.limit());
        StreamCssTokenizer tt = new StreamCssTokenizer((Reader)new CharBufferReader(buf));
        Object p = null;
        try {
            if (tt.next() == -2) {
                if (!this.nullable) {
                    throw new ParseException("String expected. " + tt.current(), buf.position());
                }
                if ("none".equals(tt.currentString())) {
                    buf.position(buf.limit());
                    return null;
                }
            }
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        BezierPathBuilder builder = new BezierPathBuilder();
        SvgPaths.buildSvgString((PathBuilder)builder, (String)input);
        BezierPath path = builder.build();
        return path;
    }

    public <TT extends BezierPath> void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable TT value) throws IOException {
        if (value == null) {
            if (!this.nullable) {
                throw new IllegalArgumentException("value");
            }
            out.append("none");
            return;
        }
        out.append(SvgPaths.awtPathIteratorToDoubleSvgString((PathIterator)value.getPathIterator(null)));
    }

    public @Nullable BezierPath getDefaultValue() {
        return this.nullable ? null : BezierPath.of();
    }
}

