/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.draw.xml.converter;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.jhotdraw8.base.converter.Converter;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;
import org.jhotdraw8.base.io.CharBufferReader;
import org.jhotdraw8.css.parser.CssTokenizer;
import org.jhotdraw8.css.parser.StreamCssTokenizer;
import org.jhotdraw8.draw.connector.Connector;
import org.jhotdraw8.draw.connector.EllipseConnector;
import org.jhotdraw8.draw.connector.LocatorConnector;
import org.jhotdraw8.draw.connector.PathConnector;
import org.jhotdraw8.draw.connector.RectangleConnector;
import org.jhotdraw8.draw.css.converter.LocatorCssConverter;
import org.jhotdraw8.draw.locator.Locator;
import org.jspecify.annotations.Nullable;

public class ConnectorXmlConverter
implements Converter<Connector> {
    private final LocatorCssConverter locatorConverter = new LocatorCssConverter();
    private static final HashMap<String, Function<Locator, Connector>> choiceToConnectorMap = new HashMap();
    private static final HashMap<Class<? extends Connector>, String> connectorToChoiceMap = new HashMap();

    public void toString(Appendable out, @Nullable IdSupplier idSupplier, @Nullable Connector value) throws IOException {
        if (value == null) {
            out.append("none");
        }
        String name = connectorToChoiceMap.get(value.getClass());
        Objects.requireNonNull(name, "unsupported connector:" + String.valueOf(value));
        out.append(name);
        if (value instanceof LocatorConnector) {
            LocatorConnector lc = (LocatorConnector)value;
            out.append(" ");
            this.locatorConverter.toString(out, idSupplier, lc.getLocator());
        }
    }

    public @Nullable Connector fromString(CharBuffer buf, @Nullable IdResolver idResolver) throws ParseException {
        Connector c;
        StreamCssTokenizer tt = new StreamCssTokenizer((Reader)new CharBufferReader(buf));
        try {
            c = this.parseConnector((CssTokenizer)tt, idResolver);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        if (!buf.toString().trim().isEmpty()) {
            throw new ParseException("Locator: End expected, found:" + String.valueOf(buf), buf.position());
        }
        return c;
    }

    public @Nullable Connector getDefaultValue() {
        return null;
    }

    public @Nullable Connector parseConnector(CssTokenizer tt, IdResolver idResolver) throws ParseException, IOException {
        Function<Locator, Connector> supplier;
        switch (tt.next()) {
            case -2: {
                if ("none".equals(tt.currentString())) {
                    return null;
                }
                supplier = choiceToConnectorMap.get(tt.currentString());
                if (supplier != null) break;
                throw new ParseException("Connector: unsupported connector, found:" + tt.currentValue(), tt.getStartPosition());
            }
            default: {
                throw new ParseException("Connector: identifier expected, found:" + tt.currentValue(), tt.getStartPosition());
            }
        }
        Locator locator = this.locatorConverter.parseNonNull(tt, idResolver);
        return supplier.apply(locator);
    }

    static {
        connectorToChoiceMap.put(PathConnector.class, "path");
        connectorToChoiceMap.put(RectangleConnector.class, "rect");
        connectorToChoiceMap.put(EllipseConnector.class, "ellipse");
        choiceToConnectorMap.put("path", PathConnector::new);
        choiceToConnectorMap.put("rect", RectangleConnector::new);
        choiceToConnectorMap.put("ellipse", EllipseConnector::new);
    }
}

