/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.beans;

import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.fxcollection.MapEntryProperty;
import org.jhotdraw8.fxcollection.typesafekey.Key;
import org.jhotdraw8.fxcollection.typesafekey.MapAccessor;
import org.jhotdraw8.fxcollection.typesafekey.NonNullMapAccessor;

public interface PropertyBean {
    public @NonNull ObservableMap<Key<?>, Object> getProperties();

    default public <T> @NonNull ObjectProperty<T> getProperty(@NonNull Key<T> key) {
        return new MapEntryProperty(this.getProperties(), key, key.getValueType());
    }

    default public <T> void set(@NonNull MapAccessor<T> key, @Nullable T newValue) {
        key.set(this.getProperties(), newValue);
    }

    default public <T> void setNonNull(@NonNull NonNullMapAccessor<T> key, @NonNull T newValue) {
        key.set(this.getProperties(), newValue);
    }

    default public <T> @Nullable T put(@NonNull MapAccessor<T> key, @Nullable T newValue) {
        return (T)key.put(this.getProperties(), newValue);
    }

    default public <T> @Nullable T get(@NonNull MapAccessor<T> key) {
        return (T)key.get(this.getProperties());
    }

    default public <T> @NonNull T getNonNull(@NonNull NonNullMapAccessor<T> key) {
        Object value = key.get(this.getProperties());
        return (T)Objects.requireNonNull(value, "value is null for key=" + String.valueOf(key));
    }

    default public <T> @Nullable T remove(Key<T> key) {
        return key.getRawValueType().cast(this.getProperties().remove(key));
    }

    default public <T> @NonNull ObservableValue<T> valueAt(Key<T> key) {
        return Bindings.valueAt(this.getProperties(), key);
    }
}

