/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

class ListToSetTransformContentBinding<D, S>
implements SetChangeListener<S> {
    private final ObservableList<D> dest;
    private final ObservableSet<S> source;
    private final Function<S, D> toDest;
    private final Consumer<D> disposeDest;

    ListToSetTransformContentBinding(@NonNull ObservableList<D> dest, @NonNull ObservableSet<S> source, @Nullable Function<S, D> toDest) {
        this(dest, source, toDest, null);
    }

    ListToSetTransformContentBinding(@NonNull ObservableList<D> dest, @NonNull ObservableSet<S> source, @Nullable Function<S, D> toDest, @Nullable Consumer<D> disposeDest) {
        this.dest = dest;
        this.source = source;
        this.toDest = toDest == null ? s -> null : toDest;
        this.disposeDest = disposeDest;
        if (toDest != null) {
            dest.clear();
            for (Object s2 : source) {
                D d = toDest.apply(s2);
                dest.add(d);
            }
        }
    }

    public void onChanged(SetChangeListener.Change<? extends S> change) {
        int i;
        if (change.wasRemoved() && (i = this.dest.indexOf(this.toDest.apply(change.getElementRemoved()))) != -1) {
            Object removed = this.dest.get(i);
            this.dest.remove(i);
            if (this.disposeDest != null) {
                this.disposeDest.accept(removed);
            }
        }
        if (change.wasAdded()) {
            this.dest.add(this.toDest.apply(change.getElementAdded()));
        }
    }

    public int hashCode() {
        return System.identityHashCode(this.dest);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ListToSetTransformContentBinding) {
            ListToSetTransformContentBinding that = (ListToSetTransformContentBinding)obj;
            return this.dest == that.dest && this.source == that.source;
        }
        return false;
    }
}

