/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

class ListTransformContentBinding<D, S> {
    private final @NonNull ObservableList<D> dest;
    private final @NonNull ObservableList<S> source;
    private final @NonNull Function<S, D> toDest;
    private final @Nullable Function<D, S> toSource;
    private final @Nullable Consumer<D> destOnRemove;
    private final @Nullable Consumer<S> sourceOnRemove;
    private int isChanging;
    private final ListChangeListener<S> sourceChangeListener = this::onSourceChanged;
    private final ListChangeListener<D> destChangeListener = this::onDestChanged;

    ListTransformContentBinding(@NonNull ObservableList<D> dest, @NonNull ObservableList<S> source, @NonNull Function<S, D> toDest, @Nullable Function<D, S> toSource, @Nullable Consumer<D> destOnRemove, @Nullable Consumer<S> sourceOnRemove) {
        this.dest = dest;
        this.source = source;
        this.toDest = toDest;
        this.toSource = toSource;
        this.destOnRemove = destOnRemove;
        this.sourceOnRemove = sourceOnRemove;
        ++this.isChanging;
        if (destOnRemove != null) {
            for (Object d : dest) {
                destOnRemove.accept(d);
            }
        }
        dest.clear();
        for (Object s : source) {
            D d = toDest.apply(s);
            dest.add(d);
        }
        --this.isChanging;
    }

    public ListChangeListener<S> getSourceChangeListener() {
        return this.sourceChangeListener;
    }

    public ListChangeListener<D> getDestChangeListener() {
        return this.destChangeListener;
    }

    private void onSourceChanged(ListChangeListener.Change<? extends S> change) {
        if (this.isChanging++ == 0) {
            while (change.next()) {
                int i;
                ArrayList<D> d;
                int from = change.getFrom();
                int to = change.getTo();
                ObservableList s = change.getList();
                if (change.wasPermutated()) {
                    this.remove(this.dest, from, to, this.destOnRemove);
                    d = new ArrayList(to - from);
                    for (i = from; i < to; ++i) {
                        d.add(this.toDest.apply(s.get(i)));
                    }
                    this.dest.addAll(from, d);
                    continue;
                }
                if (change.wasRemoved()) {
                    this.remove(this.dest, from, from + change.getRemovedSize(), this.destOnRemove);
                }
                if (!change.wasAdded()) continue;
                d = new ArrayList<D>(to - from);
                for (i = from; i < to; ++i) {
                    d.add(this.toDest.apply(s.get(i)));
                }
                this.dest.addAll(from, d);
            }
        }
        --this.isChanging;
    }

    private void onDestChanged(ListChangeListener.Change<? extends D> change) {
        Function<D, S> myToSource = this.toSource;
        if (myToSource == null) {
            return;
        }
        if (this.isChanging++ == 0) {
            while (change.next()) {
                int i;
                ArrayList<S> s;
                int from = change.getFrom();
                int to = change.getTo();
                ObservableList d = change.getList();
                if (change.wasPermutated()) {
                    this.remove(this.source, from, to, this.sourceOnRemove);
                    s = new ArrayList(to - from);
                    for (i = from; i < to; ++i) {
                        s.add(myToSource.apply(d.get(i)));
                    }
                    this.source.addAll(from, s);
                    continue;
                }
                if (change.wasRemoved()) {
                    this.remove(this.source, from, from + change.getRemovedSize(), this.sourceOnRemove);
                }
                if (!change.wasAdded()) continue;
                s = new ArrayList<S>(to - from);
                for (i = from; i < to; ++i) {
                    s.add(this.toSource.apply(d.get(i)));
                }
                this.source.addAll(from, s);
            }
        }
        --this.isChanging;
    }

    private <E> void remove(ObservableList<E> list, int from, int to, Consumer<E> onRemove) {
        if (onRemove != null) {
            for (int i = from; i < to; ++i) {
                onRemove.accept(list.get(i));
            }
        }
        list.remove(from, to);
    }
}

