/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.binding;

import java.lang.ref.WeakReference;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jhotdraw8.annotation.NonNull;

public class Via<T> {
    private final @NonNull WeakReference<Property<?>> weakReferenceToRoot;
    private final @NonNull Property<T> intermediate;

    public Via(@NonNull Property<T> weakReferenceToRoot) {
        this.weakReferenceToRoot = new WeakReference<Property<T>>(weakReferenceToRoot);
        this.intermediate = weakReferenceToRoot;
    }

    private Via(@NonNull WeakReference<Property<?>> weakReferenceToRoot, @NonNull Property<T> intermediate) {
        this.weakReferenceToRoot = weakReferenceToRoot;
        this.intermediate = intermediate;
    }

    public <U> Via<U> via(@NonNull Function<T, Property<U>> viaFunction) {
        ViaChangeListener<Object, U> changeListener = new ViaChangeListener<Object, U>(this.weakReferenceToRoot, this.intermediate, viaFunction);
        changeListener.changed((ObservableValue<Object>)this.intermediate, null, this.intermediate.getValue());
        this.intermediate.addListener(changeListener);
        return new Via(this.weakReferenceToRoot, changeListener.next);
    }

    public Property<T> get() {
        return this.intermediate;
    }

    private static class ViaChangeListener<T, U>
    implements ChangeListener<T> {
        private final @NonNull ObjectProperty<U> next = new SimpleObjectProperty();
        private final @NonNull Function<T, Property<U>> viaFunction;
        private final @NonNull WeakReference<Property<?>> weakReferenceToRoot;
        private final @NonNull Property<T> intermediate;

        private ViaChangeListener(@NonNull WeakReference<Property<?>> weakReferenceToRoot, @NonNull Property<T> intermediate, @NonNull Function<T, Property<U>> viaFunction) {
            this.viaFunction = viaFunction;
            this.weakReferenceToRoot = weakReferenceToRoot;
            this.intermediate = intermediate;
        }

        public void changed(ObservableValue<? extends T> o, T oldv, T newv) {
            if (oldv != null) {
                this.next.unbindBidirectional(this.viaFunction.apply(oldv));
            }
            if (this.weakReferenceToRoot.get() == null) {
                this.intermediate.removeListener((ChangeListener)this);
                return;
            }
            if (newv != null) {
                this.next.bindBidirectional(this.viaFunction.apply(newv));
            }
        }
    }
}

