/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.base.concurrent.CheckedFunction;
import org.jhotdraw8.base.concurrent.CheckedRunnable;
import org.jhotdraw8.fxbase.concurrent.CompletableWorker;
import org.jhotdraw8.fxbase.concurrent.SimpleCompletableWorker;
import org.jhotdraw8.fxbase.concurrent.WorkState;

public class FXWorker {
    private FXWorker() {
    }

    public static @NonNull CompletableFuture<Void> run(@NonNull CheckedRunnable runnable) {
        return FXWorker.run(ForkJoinPool.commonPool(), runnable);
    }

    public static @NonNull CompletableFuture<Void> run(@NonNull Executor executor, @NonNull CheckedRunnable runnable) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        Runnable worker = () -> {
            try {
                runnable.run();
                Platform.runLater(() -> f.complete(null));
            }
            catch (Exception e) {
                Platform.runLater(() -> f.completeExceptionally(e));
            }
        };
        executor.execute(worker);
        return f;
    }

    public static <T> @NonNull CompletableFuture<T> supply(@NonNull Callable<T> supplier) {
        return FXWorker.supply(ForkJoinPool.commonPool(), supplier);
    }

    public static <T> @NonNull CompletableFuture<T> supply(@NonNull Executor executor, @NonNull Callable<T> supplier) {
        CompletableFuture f = new CompletableFuture();
        executor.execute(() -> {
            try {
                Object result = supplier.call();
                Platform.runLater(() -> f.complete(result));
            }
            catch (Throwable e) {
                Platform.runLater(() -> f.completeExceptionally(e));
            }
        });
        return f;
    }

    public static <T> @NonNull CompletableWorker<T> work(@NonNull Executor executor, @NonNull CheckedFunction<WorkState<T>, T> supplier, @NonNull WorkState<T> workState) {
        SimpleCompletableWorker w = new SimpleCompletableWorker(workState);
        w.updateState(Worker.State.SCHEDULED);
        executor.execute(() -> {
            try {
                w.updateState(Worker.State.RUNNING);
                Object result = supplier.apply((Object)workState);
                Platform.runLater(() -> w.complete(result));
            }
            catch (Throwable e) {
                Platform.runLater(() -> w.completeExceptionally(e));
            }
        });
        return w;
    }
}

