/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.control;

import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.util.Callback;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class BooleanPropertyCheckBoxTreeTableCell<S>
extends TreeTableCell<S, Boolean> {
    private final CheckBox checkBox = new CheckBox();

    public BooleanPropertyCheckBoxTreeTableCell(@Nullable String styleClass) {
        this.checkBox.selectedProperty().addListener(this::commitSelectionChange);
        if (styleClass != null) {
            this.checkBox.getStyleClass().add((Object)styleClass);
        }
    }

    public void updateItem(@Nullable Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(" ");
            this.setGraphic((Node)this.checkBox);
            this.checkBox.setSelected(item.booleanValue());
        }
    }

    public static <S> @NonNull Callback<TreeTableColumn<S, Boolean>, TreeTableCell<S, Boolean>> forTreeTableColumn() {
        return BooleanPropertyCheckBoxTreeTableCell.forTreeTableColumn(null);
    }

    public static <S> @NonNull Callback<TreeTableColumn<S, Boolean>, TreeTableCell<S, Boolean>> forTreeTableColumn(@Nullable String styleClass) {
        return list -> new BooleanPropertyCheckBoxTreeTableCell(styleClass);
    }

    private void commitSelectionChange(Observable o) {
        Property p = (Property)this.getTableColumn().getCellObservableValue(this.getIndex());
        if (((Boolean)p.getValue()).booleanValue() != this.checkBox.isSelected()) {
            p.setValue((Object)this.checkBox.isSelected());
        }
    }
}

