/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.event;

import java.lang.ref.WeakReference;
import java.util.EventObject;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.WeakListener;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Listener;

public final class SimpleWeakListener<E extends EventObject>
implements Listener<E>,
WeakListener {
    private final @NonNull WeakReference<Listener<E>> ref;
    private final Consumer<Listener<E>> removeListener;

    public SimpleWeakListener(@Nullable Listener<E> listener, Consumer<Listener<E>> removeListener) {
        Objects.requireNonNull(listener, "listener");
        this.ref = new WeakReference<Listener<E>>(listener);
        this.removeListener = removeListener;
    }

    public boolean wasGarbageCollected() {
        return this.ref.get() == null;
    }

    public void handle(E event) {
        Listener listener = (Listener)this.ref.get();
        if (listener != null) {
            listener.handle(event);
        } else {
            this.removeListener.accept(this);
        }
    }
}

