/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.fxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.util.Callback;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class FxmlUtil {
    private FxmlUtil() {
    }

    public static <T> @NonNull Supplier<T> createFxmlControllerSupplier(@NonNull URL fxml, @NonNull ResourceBundle resources) {
        return FxmlUtil.createFxmlControllerSupplier(fxml, resources, (Callback)null);
    }

    public static <T> @NonNull Supplier<T> createFxmlControllerSupplier(@NonNull URL fxml, @NonNull ResourceBundle resources, @Nullable Supplier<T> controllerFactory) {
        return () -> FxmlUtil.createFxmlControllerSupplier(fxml, resources, controllerFactory == null ? null : arg_0 -> FxmlUtil.lambda$createFxmlControllerSupplier$0((Supplier)controllerFactory, arg_0)).get();
    }

    public static <T> @NonNull Supplier<T> createFxmlControllerSupplier(@NonNull URL fxml, @NonNull ResourceBundle resources, @Nullable Callback<Class<?>, Object> controllerFactory) {
        return () -> {
            Object object;
            block8: {
                FXMLLoader loader = new FXMLLoader();
                loader.setResources(resources);
                loader.setControllerFactory(controllerFactory);
                InputStream in = fxml.openStream();
                try {
                    loader.load(in);
                    object = loader.getController();
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                in.close();
            }
            return object;
        };
    }

    public static <T extends Node> @NonNull Supplier<T> createFxmlNodeSupplier(@NonNull URL fxml, @Nullable ResourceBundle resourceBundle) {
        return () -> {
            Node node;
            block8: {
                FXMLLoader loader = new FXMLLoader();
                loader.setResources(resourceBundle);
                InputStream in = fxml.openStream();
                try {
                    node = (Node)loader.load(in);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new InternalError(ex);
                    }
                }
                in.close();
            }
            return node;
        };
    }

    public static FXMLLoader load(@Nullable URL fxml, @Nullable ResourceBundle resourceBundle) {
        FXMLLoader loader = new FXMLLoader();
        loader.setResources(resourceBundle);
        try (InputStream in = fxml.openStream();){
            loader.load(in);
        }
        catch (IOException ex) {
            throw new InternalError(ex);
        }
        return loader;
    }

    private static /* synthetic */ Object lambda$createFxmlControllerSupplier$0(Supplier controllerFactory, Class clazz) {
        return controllerFactory.get();
    }
}

