/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.transition;

import javafx.animation.Transition;
import javafx.geometry.Bounds;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class RectangleTransition
extends Transition {
    private final Rectangle rectangle;
    private final Bounds fromBounds;
    private final Bounds toBounds;

    public RectangleTransition(Duration duration, Rectangle rectangle, Bounds fromBounds, Bounds toBounds) {
        this.rectangle = rectangle;
        this.fromBounds = fromBounds;
        this.toBounds = toBounds;
        this.setCycleDuration(duration);
    }

    public Bounds getFromBounds() {
        return this.fromBounds;
    }

    public Bounds getToBounds() {
        return this.toBounds;
    }

    protected void interpolate(double frac) {
        double invFrac = 1.0 - frac;
        this.rectangle.setWidth(this.fromBounds.getWidth() * invFrac + this.toBounds.getWidth() * frac);
        this.rectangle.setHeight(this.fromBounds.getHeight() * invFrac + this.toBounds.getHeight() * frac);
        this.rectangle.setX(this.fromBounds.getMinX() * invFrac + this.toBounds.getMinX() * frac);
        this.rectangle.setY(this.fromBounds.getMinY() * invFrac + this.toBounds.getMinY() * frac);
    }
}

