/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javafx.scene.control.TreeItem;

public class ExpandedTreeItemIterator<T>
implements Iterator<TreeItem<T>> {
    private final Deque<Iterator<TreeItem<T>>> stack = new ArrayDeque<Iterator<TreeItem<T>>>(16);

    public ExpandedTreeItemIterator(TreeItem<T> root) {
        this.stack.push(Collections.singleton(root).iterator());
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty() && this.stack.peek().hasNext();
    }

    @Override
    public TreeItem<T> next() {
        Iterator children;
        Iterator<TreeItem<T>> iter = this.stack.peek();
        if (iter == null) {
            throw new NoSuchElementException();
        }
        TreeItem<T> node = iter.next();
        if (!iter.hasNext()) {
            this.stack.pop();
        }
        if (node.isExpanded() && (children = node.getChildren().iterator()).hasNext()) {
            this.stack.push(children);
        }
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

