/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Function;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.collection.enumerator.AbstractEnumerator;

public class TreeDepthFirstSpliterator<V>
extends AbstractEnumerator<V> {
    private final @NonNull Function<V, Iterable<V>> nextFunction;
    private final @NonNull Deque<V> deque;

    public TreeDepthFirstSpliterator(@NonNull Function<V, Iterable<V>> nextFunction, @NonNull V root) {
        super(Long.MAX_VALUE, 273);
        Objects.requireNonNull(nextFunction, "nextFunction");
        Objects.requireNonNull(root, "root");
        this.nextFunction = nextFunction;
        this.deque = new ArrayDeque<V>(16);
        this.deque.add(root);
    }

    public boolean moveNext() {
        this.current = this.deque.pollLast();
        if (this.current == null) {
            return false;
        }
        for (V next : this.nextFunction.apply(this.current)) {
            this.deque.addLast(next);
        }
        return true;
    }
}

