/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.tree;

import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.event.Event;
import org.jhotdraw8.fxbase.tree.TreeModel;

public class TreeModelEvent<N>
extends Event<TreeModel<N>> {
    private static final long serialVersionUID = 1L;
    private final N node;
    private final N parentOrOldRoot;
    private final N root;
    private final int childIndex;
    private final EventType eventType;

    private TreeModelEvent(@NonNull TreeModel<N> source, EventType eventType, N node, N parentOrOldRoot, N root, int childIndex) {
        super(source);
        this.node = node;
        this.parentOrOldRoot = parentOrOldRoot;
        this.root = root;
        this.childIndex = childIndex;
        this.eventType = eventType;
    }

    public static <E> @NonNull TreeModelEvent<E> subtreeNodesInvalidated(@NonNull TreeModel<E> source, E subtreeRot) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.SUBTREE_NODES_CHANGED, subtreeRot, null, null, -1);
    }

    public static <E> @NonNull TreeModelEvent<E> nodeAddedToParent(@NonNull TreeModel<E> source, E child, E parent, int index) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.NODE_ADDED_TO_PARENT, child, parent, null, index);
    }

    public static <E> @NonNull TreeModelEvent<E> nodeRemovedFromParent(@NonNull TreeModel<E> source, E child, E parent, int index) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.NODE_REMOVED_FROM_PARENT, child, parent, null, index);
    }

    public static <E> @NonNull TreeModelEvent<E> nodeAddedToTree(@NonNull TreeModel<E> source, E root, E node) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.NODE_ADDED_TO_TREE, node, null, root, -1);
    }

    public static <E> @NonNull TreeModelEvent<E> nodeRemovedFromTree(@NonNull TreeModel<E> source, E root, E node) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.NODE_REMOVED_FROM_TREE, node, null, root, -1);
    }

    public static <E> @NonNull TreeModelEvent<E> nodeChanged(@NonNull TreeModel<E> source, E node) {
        return new TreeModelEvent<Object>((TreeModel<Object>)source, EventType.NODE_CHANGED, node, null, null, -1);
    }

    public static <E> @NonNull TreeModelEvent<E> rootChanged(@NonNull TreeModel<E> source, @Nullable E oldRoot, @Nullable E newRoot) {
        return new TreeModelEvent<E>(source, EventType.ROOT_CHANGED, newRoot, oldRoot, newRoot, -1);
    }

    public @Nullable N getOldRoot() {
        if (EventType.ROOT_CHANGED != this.eventType) {
            throw new IllegalStateException();
        }
        return this.parentOrOldRoot;
    }

    public @Nullable N getNewRoot() {
        if (EventType.ROOT_CHANGED != this.eventType) {
            throw new IllegalStateException();
        }
        return this.root;
    }

    public N getNode() {
        return this.node;
    }

    public N getParent() {
        return this.parentOrOldRoot;
    }

    public N getRoot() {
        return this.root;
    }

    public N getChild() {
        return this.node;
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public @NonNull String toString() {
        return "TreeModelEvent{node=" + String.valueOf(this.node) + ", parent=" + String.valueOf(this.parentOrOldRoot) + ", index=" + this.childIndex + ", eventType=" + String.valueOf((Object)this.eventType) + ", source=" + String.valueOf(this.source) + "}";
    }

    public static enum EventType {
        ROOT_CHANGED,
        SUBTREE_NODES_CHANGED,
        NODE_ADDED_TO_PARENT,
        NODE_REMOVED_FROM_PARENT,
        NODE_ADDED_TO_TREE,
        NODE_REMOVED_FROM_TREE,
        NODE_CHANGED;

    }
}

