/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.fxbase.undo;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.jhotdraw8.annotation.NonNull;

public class FXUndoManager
implements UndoableEditListener {
    private final @NonNull UndoManager manager;
    private final @NonNull BooleanProperty canUndo = new SimpleBooleanProperty((Object)this, "canUndo", false);
    private final @NonNull BooleanProperty canRedo = new SimpleBooleanProperty((Object)this, "canRedo", false);
    private final @NonNull StringProperty undoName = new SimpleStringProperty((Object)this, "undoName", "Undo");
    private final @NonNull StringProperty redoName = new SimpleStringProperty((Object)this, "redoName", "Redo");
    private boolean isBusy;

    public FXUndoManager() {
        this.manager = new UndoManager();
    }

    public StringProperty undoPresentationNameProperty() {
        return this.undoName;
    }

    public StringProperty redoPresentationNameProperty() {
        return this.redoName;
    }

    @Override
    public void undoableEditHappened(@NonNull UndoableEditEvent e) {
        if (!this.isBusy) {
            this.manager.undoableEditHappened(e);
            this.updateProperties();
        }
    }

    public @NonNull BooleanProperty undoableProperty() {
        return this.canUndo;
    }

    public @NonNull BooleanProperty redoableProperty() {
        return this.canRedo;
    }

    private void updateProperties() {
        this.canUndo.set(this.manager.canUndo());
        this.canRedo.set(this.manager.canRedo());
        this.undoPresentationNameProperty().set((Object)this.manager.getUndoPresentationName());
        this.redoPresentationNameProperty().set((Object)this.manager.getRedoPresentationName());
    }

    public void redo() {
        if (this.manager.canRedo()) {
            this.isBusy = true;
            try {
                this.manager.redo();
            }
            finally {
                this.updateProperties();
                this.isBusy = false;
            }
        }
    }

    public void undo() {
        if (this.manager.canUndo()) {
            this.isBusy = true;
            try {
                this.manager.undo();
            }
            finally {
                this.updateProperties();
                this.isBusy = false;
            }
        }
    }

    public boolean canUndo() {
        return this.canUndo.get();
    }

    public boolean canRedo() {
        return this.canRedo.get();
    }

    public void discardAllEdits() {
        this.manager.discardAllEdits();
        this.updateProperties();
    }
}

